/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.vec.uv;

import codechicken.lib.math.MathHelper;
import codechicken.lib.vec.uv.UV;
import codechicken.lib.vec.uv.UVTransformation;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.jetbrains.annotations.Nullable;

public class UVRotation
extends UVTransformation {
    public double angle;

    public UVRotation(double angle) {
        this.angle = angle;
    }

    public UVRotation(UVRotation other) {
        this(other.angle);
    }

    @Override
    public void apply(UV uv) {
        double c = Math.cos(this.angle);
        double s = Math.sin(this.angle);
        double u2 = c * uv.u + s * uv.v;
        uv.v = -s * uv.u + c * uv.v;
        uv.u = u2;
    }

    @Override
    public UVTransformation inverse() {
        return new UVRotation(-this.angle);
    }

    @Override
    @Nullable
    public UVTransformation merge(UVTransformation next) {
        if (next instanceof UVRotation) {
            return new UVRotation(this.angle + ((UVRotation)next).angle);
        }
        return null;
    }

    @Override
    public boolean isRedundant() {
        return MathHelper.between(-1.0E-5, this.angle, 1.0E-5);
    }

    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return "UVRotation(" + String.valueOf(new BigDecimal(this.angle, cont)) + ")";
    }

    @Override
    public UVRotation copy() {
        return new UVRotation(this);
    }
}

