/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.lib.container;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.inventory.container.data.AbstractDataStore;
import codechicken.lib.inventory.container.modular.ModularGuiContainerMenu;
import java.util.function.Supplier;

public class DataSync<T> {
    public static final int PKT_SEND_CHANGES = 255;
    private final ModularGuiContainerMenu containerMenu;
    private final AbstractDataStore<T> dataStore;
    private final Supplier<T> valueGetter;

    public DataSync(ModularGuiContainerMenu containerMenu, AbstractDataStore<T> dataStore, Supplier<T> valueGetter) {
        this.containerMenu = containerMenu;
        this.dataStore = dataStore;
        this.valueGetter = valueGetter;
        containerMenu.dataSyncs.add(this);
    }

    public T get() {
        return this.dataStore.get();
    }

    public void detectAndSend() {
        if (this.dataStore.isSameValue(this.valueGetter.get())) {
            return;
        }
        this.dataStore.set(this.valueGetter.get());
        this.containerMenu.sendPacketToClient(255, buf -> {
            buf.writeByte((byte)this.containerMenu.dataSyncs.indexOf(this));
            this.dataStore.toBytes((MCDataOutput)buf);
        });
    }

    public void handleSyncPacket(MCDataInput buf) {
        this.dataStore.fromBytes(buf);
    }
}

