/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import tfar.dankstorage.DankStorage;

public class SerializationHelper {
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> LARGE_OPTIONAL_STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){
        private static final StreamCodec<RegistryFriendlyByteBuf, Holder<Item>> ITEM_STREAM_CODEC = ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM);

        public ItemStack decode(RegistryFriendlyByteBuf buf) {
            int i = buf.readInt();
            if (i <= 0) {
                return ItemStack.EMPTY;
            }
            Holder holder = (Holder)ITEM_STREAM_CODEC.decode((Object)buf);
            DataComponentPatch datacomponentpatch = (DataComponentPatch)DataComponentPatch.STREAM_CODEC.decode((Object)buf);
            return new ItemStack(holder, i, datacomponentpatch);
        }

        public void encode(RegistryFriendlyByteBuf buf, ItemStack stack) {
            if (stack.isEmpty()) {
                buf.writeInt(0);
            } else {
                buf.writeInt(stack.getCount());
                ITEM_STREAM_CODEC.encode((Object)buf, (Object)stack.getItemHolder());
                DataComponentPatch.STREAM_CODEC.encode((Object)buf, (Object)((PatchedDataComponentMap)stack.getComponents()).asPatch());
            }
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStack>> LARGE_OPTIONAL_LIST_STREAM_CODEC = LARGE_OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity));
    public static final Codec<ItemStack> LARGE_CODEC = RecordCodecBuilder.create(p_347288_ -> p_347288_.group((App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)ExtraCodecs.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("count").orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(stack -> ((PatchedDataComponentMap)stack.getComponents()).asPatch())).apply((Applicative)p_347288_, ItemStack::new));

    public static Tag encodeLargeStack(ItemStack stack, HolderLookup.Provider provider, CompoundTag tag) {
        return (Tag)LARGE_CODEC.encode((Object)stack, (DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).getOrThrow();
    }

    public static ItemStack decodeLargeItemStack(HolderLookup.Provider provider, CompoundTag tag) {
        if (tag.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return LARGE_CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(string -> DankStorage.LOG.error("Tried to load invalid item: '{}'", string)).orElse(ItemStack.EMPTY);
    }

    public static void writeExtendedItemStack(RegistryFriendlyByteBuf buf, ItemStack stack) {
        LARGE_OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)stack);
    }

    public static ItemStack readExtendedItemStack(RegistryFriendlyByteBuf buf) {
        return (ItemStack)LARGE_OPTIONAL_STREAM_CODEC.decode((Object)buf);
    }

    public static void writeList(RegistryFriendlyByteBuf buf, List<ItemStack> stacks) {
        LARGE_OPTIONAL_LIST_STREAM_CODEC.encode((Object)buf, stacks);
    }

    public static List<ItemStack> readList(RegistryFriendlyByteBuf buf) {
        return (List)LARGE_OPTIONAL_LIST_STREAM_CODEC.decode((Object)buf);
    }

    public static <B extends FriendlyByteBuf, V extends Enum<V>> StreamCodec<B, V> enumCodec(final Class<V> enumClass) {
        return new StreamCodec<B, V>(){

            public V decode(B buf) {
                return buf.readEnum(enumClass);
            }

            public void encode(B buf, V value) {
                buf.writeEnum(value);
            }
        };
    }
}

