/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.utils;

import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.init.ModDataComponentTypes;
import tfar.dankstorage.inventory.DankInventory;
import tfar.dankstorage.inventory.LimitedContainerData;
import tfar.dankstorage.item.DankItem;
import tfar.dankstorage.menu.ChangeFrequencyMenu;
import tfar.dankstorage.menu.DankMenu;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.utils.TxtColor;
import tfar.dankstorage.world.DankSavedData;

public class CommonUtils {
    public static final int INVALID = -1;
    private static final DecimalFormat decimalFormat = new DecimalFormat("0.##");
    private static List<CraftingRecipe> REVERSIBLE3x3 = new ArrayList<CraftingRecipe>();
    private static List<CraftingRecipe> REVERSIBLE2x2 = new ArrayList<CraftingRecipe>();
    private static boolean cached = false;

    public static String formatLargeNumber(int number) {
        if (number >= 1000000000) {
            return decimalFormat.format((float)number / 1.0E9f) + "b";
        }
        if (number >= 1000000) {
            return decimalFormat.format((float)number / 1000000.0f) + "m";
        }
        if (number >= 1000) {
            return decimalFormat.format((float)number / 1000.0f) + "k";
        }
        return Float.toString(number).replaceAll("\\.?0*$", "");
    }

    public static void uncacheRecipes() {
        cached = false;
    }

    public static Pair<ItemStack, Integer> compress(ItemStack stack, RegistryAccess registryAccess) {
        for (CraftingRecipe recipe : REVERSIBLE3x3) {
            if (!((Ingredient)recipe.getIngredients().getFirst()).test(stack)) continue;
            return Pair.of((Object)recipe.getResultItem((HolderLookup.Provider)registryAccess), (Object)9);
        }
        for (CraftingRecipe recipe : REVERSIBLE2x2) {
            if (!((Ingredient)recipe.getIngredients().getFirst()).test(stack)) continue;
            return Pair.of((Object)recipe.getResultItem((HolderLookup.Provider)registryAccess), (Object)4);
        }
        return Pair.of((Object)ItemStack.EMPTY, (Object)0);
    }

    public static Pair<ItemStack, ItemStack> getCompressingResult(ItemStack stack, ServerLevel level) {
        if (!CommonUtils.canCompress(level, stack)) {
            return Pair.of((Object)stack, (Object)ItemStack.EMPTY);
        }
        Pair<ItemStack, Integer> result = CommonUtils.compress(stack, level.registryAccess());
        ItemStack compressedStack = ((ItemStack)result.getFirst()).copyWithCount(stack.getCount() / (Integer)result.getSecond());
        ItemStack remainder = stack.copyWithCount(stack.getCount() % (Integer)result.getSecond());
        return Pair.of((Object)remainder, (Object)compressedStack);
    }

    public static boolean canCompress(ServerLevel level, ItemStack stack) {
        if (!cached) {
            REVERSIBLE3x3 = CommonUtils.findReversibles(level, 3);
            REVERSIBLE2x2 = CommonUtils.findReversibles(level, 2);
            cached = true;
        }
        for (CraftingRecipe recipe : REVERSIBLE3x3) {
            if (!((Ingredient)recipe.getIngredients().getFirst()).test(stack)) continue;
            return stack.getCount() >= 9;
        }
        for (CraftingRecipe recipe : REVERSIBLE2x2) {
            if (!((Ingredient)recipe.getIngredients().getFirst()).test(stack)) continue;
            return stack.getCount() >= 4;
        }
        return false;
    }

    public static void setPickSlot(Level level, ItemStack bag, ItemStack stack) {
        List<ItemStack> gathered;
        DankInventory dankInventory = DankItem.getInventoryFrom(bag, level.getServer());
        if (dankInventory != null && !(gathered = dankInventory.getUniqueItems()).isEmpty()) {
            for (ItemStack itemStack : gathered) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack)) continue;
                DankItem.setSelectedItem(bag, itemStack);
                break;
            }
        }
    }

    public static List<CraftingRecipe> findReversibles(ServerLevel level, int size) {
        ArrayList<CraftingRecipe> compactingRecipes = new ArrayList<CraftingRecipe>();
        List recipes = level.getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING);
        for (RecipeHolder recipe : recipes) {
            NonNullList inputs;
            Ingredient first;
            Recipe recipe2 = recipe.value();
            if (!(recipe2 instanceof ShapedRecipe)) continue;
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe2;
            int x = shapedRecipe.getWidth();
            int y = shapedRecipe.getHeight();
            if (x != size || x != y || (first = (Ingredient)(inputs = shapedRecipe.getIngredients()).getFirst()) == Ingredient.EMPTY) continue;
            boolean same = true;
            for (int i = 1; i < x * y; ++i) {
                Ingredient next = (Ingredient)inputs.get(i);
                if (next == first) continue;
                same = false;
                break;
            }
            if (!same || shapedRecipe.getResultItem((HolderLookup.Provider)level.registryAccess()).getCount() != 1) continue;
            ItemStack stack = shapedRecipe.getResultItem((HolderLookup.Provider)level.registryAccess());
            level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)CommonUtils.makeCraftInput(stack), (Level)level).ifPresent(reverseRecipe -> {
                if (((CraftingRecipe)reverseRecipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).getCount() == size * size) {
                    compactingRecipes.add((CraftingRecipe)shapedRecipe);
                }
            });
        }
        return compactingRecipes;
    }

    private static CraftingInput makeCraftInput(ItemStack stack) {
        return CraftingInput.of((int)1, (int)1, List.of(stack));
    }

    public static void merge(List<ItemStack> stacks, ItemStack toMerge) {
        for (ItemStack stack : stacks) {
            int grow;
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)toMerge) || (grow = Math.min(Integer.MAX_VALUE - stack.getCount(), toMerge.getCount())) <= 0) continue;
            stack.grow(grow);
            toMerge.shrink(grow);
        }
        if (!toMerge.isEmpty()) {
            stacks.add(toMerge);
        }
    }

    public static MutableComponent translatable(String s) {
        return Component.translatable((String)s);
    }

    public static MutableComponent translatable(String string, Object ... objects) {
        return Component.translatable((String)string, (Object[])objects);
    }

    public static MutableComponent literal(String s) {
        return Component.literal((String)s);
    }

    public static boolean oredict(ItemStack bag) {
        return bag.has(ModDataComponentTypes.OREDICT);
    }

    public static void warn(Player player, DankStats item, DankStats inventory) {
        player.sendSystemMessage((Component)CommonUtils.literal("Dank Item Level " + item.ordinal() + " cannot open Dank Inventory Level " + inventory.ordinal()));
    }

    public static int getNbtSize(@Nullable CompoundTag nbt) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.writeNbt((Tag)nbt);
        buffer.release();
        return buffer.writerIndex();
    }

    public static boolean isHoldingDank(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() instanceof DankItem) {
            return true;
        }
        stack = player.getOffhandItem();
        return stack.getItem() instanceof DankItem;
    }

    @Nullable
    public static InteractionHand getHandWithDank(Player player) {
        if (player.getMainHandItem().getItem() instanceof DankItem) {
            return InteractionHand.MAIN_HAND;
        }
        if (player.getOffhandItem().getItem() instanceof DankItem) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    public static ItemStack getDank(Player player) {
        InteractionHand hand = CommonUtils.getHandWithDank(player);
        return hand == null ? ItemStack.EMPTY : player.getItemInHand(hand);
    }

    public static void toggleTagMode(ServerPlayer player) {
        ItemStack dank = CommonUtils.getDank((Player)player);
        if (!dank.isEmpty()) {
            boolean toggle = CommonUtils.oredict(dank);
            CommonUtils.setOredict(dank, !toggle);
        }
    }

    public static void setOredict(ItemStack bag, boolean active) {
        if (active) {
            bag.set(ModDataComponentTypes.OREDICT, (Object)Unit.INSTANCE);
        } else {
            bag.remove(ModDataComponentTypes.OREDICT);
        }
    }

    public static void togglePickupMode(ServerPlayer player) {
        ItemStack bag = CommonUtils.getDank((Player)player);
        if (!bag.isEmpty()) {
            DankItem.cyclePickupMode(bag, (Player)player);
        }
    }

    public static void toggleUseType(ServerPlayer player) {
        ItemStack dank = CommonUtils.getDank((Player)player);
        if (!dank.isEmpty()) {
            DankItem.cyclePlacement(dank, (Player)player);
        }
    }

    public static void setTxtColor(ServerPlayer player, int frequency, boolean set) {
        AbstractContainerMenu container = player.containerMenu;
        if (container instanceof DankMenu) {
            TxtColor textColor;
            DankMenu abstractDankMenu = (DankMenu)container;
            DankInventory inventory = abstractDankMenu.dankInventory;
            if (frequency > -1) {
                if (frequency < DankStorage.firstFreeId(player.server)) {
                    DankInventory targetInventory = DankSavedData.get(frequency, player.server).getOrCreateInventory();
                    if (targetInventory.slotCount() == inventory.slotCount()) {
                        if (targetInventory.frequencyLocked()) {
                            textColor = TxtColor.LOCKED;
                        } else {
                            textColor = TxtColor.GOOD;
                            if (set) {
                                abstractDankMenu.setFrequency(frequency);
                                ItemStack bag = abstractDankMenu.bag;
                                Item item = bag.getItem();
                                if (item instanceof DankItem) {
                                    DankItem dankItem = (DankItem)item;
                                    player.openMenu(dankItem.createProvider(bag));
                                }
                            }
                        }
                    } else {
                        textColor = TxtColor.DIFFERENT_TIER;
                    }
                } else {
                    textColor = TxtColor.TOO_HIGH;
                }
            } else {
                textColor = TxtColor.INVALID;
            }
            inventory.setTextColor(textColor.color);
        } else if (container instanceof ChangeFrequencyMenu) {
            TxtColor textColor;
            ChangeFrequencyMenu changeFrequencyMenu = (ChangeFrequencyMenu)container;
            DankInventory inventory = (DankInventory)((LimitedContainerData)changeFrequencyMenu.getContainerData()).getWrapped();
            if (frequency > -1) {
                if (frequency < DankStorage.firstFreeId(player.server)) {
                    DankInventory targetInventory = DankSavedData.get(frequency, player.server).getOrCreateInventory();
                    if (targetInventory.slotCount() == DankStats.values()[changeFrequencyMenu.getCurrentTier()].slots) {
                        if (targetInventory.frequencyLocked()) {
                            textColor = TxtColor.LOCKED;
                        } else {
                            textColor = TxtColor.GOOD;
                            if (set) {
                                changeFrequencyMenu.setLinkedFrequency(frequency);
                                player.closeContainer();
                            }
                        }
                    } else {
                        textColor = TxtColor.DIFFERENT_TIER;
                    }
                } else {
                    textColor = TxtColor.TOO_HIGH;
                }
            } else {
                textColor = TxtColor.INVALID;
            }
            inventory.setTextColor(textColor.color);
        }
    }
}

