/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.network.server;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import tfar.dankstorage.item.DankItem;
import tfar.dankstorage.network.DankPacketHandler;
import tfar.dankstorage.network.server.C2SModPacket;
import tfar.dankstorage.platform.Services;
import tfar.dankstorage.utils.CommonUtils;
import tfar.dankstorage.utils.KeybindAction;
import tfar.dankstorage.utils.SerializationHelper;

public record C2SButtonPacket(KeybindAction keybindAction) implements C2SModPacket
{
    public static final StreamCodec<RegistryFriendlyByteBuf, C2SButtonPacket> STREAM_CODEC = StreamCodec.composite(SerializationHelper.enumCodec(KeybindAction.class), C2SButtonPacket::keybindAction, C2SButtonPacket::new);
    public static final CustomPacketPayload.Type<C2SButtonPacket> TYPE = new CustomPacketPayload.Type(DankPacketHandler.packet(C2SButtonPacket.class));

    public static void send(KeybindAction keybindAction) {
        Services.PLATFORM.sendToServer(new C2SButtonPacket(keybindAction));
    }

    @Override
    public void handleServer(ServerPlayer player) {
        switch (this.keybindAction) {
            case TOGGLE_PICKUP: {
                CommonUtils.togglePickupMode(player);
                break;
            }
            case TOGGLE_USE_TYPE: {
                CommonUtils.toggleUseType(player);
                break;
            }
            case PICK_BLOCK: {
                ItemStack pick;
                HitResult hit = player.pick(5.0, 0.0f, false);
                if (!(hit instanceof BlockHitResult)) break;
                BlockHitResult blockHit = (BlockHitResult)hit;
                if (hit.getType() == HitResult.Type.MISS || (pick = Services.PLATFORM.getCloneStack(player.level(), blockHit.getBlockPos(), player.level().getBlockState(blockHit.getBlockPos()), hit, (Player)player)).isEmpty()) break;
                if (player.getMainHandItem().getItem() instanceof DankItem) {
                    CommonUtils.setPickSlot(player.level(), player.getMainHandItem(), pick);
                    break;
                }
                if (!(player.getOffhandItem().getItem() instanceof DankItem)) break;
                CommonUtils.setPickSlot(player.level(), player.getOffhandItem(), pick);
            }
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.keybindAction.ordinal());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

