/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.network.client;

import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import tfar.dankstorage.client.CommonClient;
import tfar.dankstorage.menu.DankMenu;
import tfar.dankstorage.network.DankPacketHandler;
import tfar.dankstorage.network.client.S2CModPacket;
import tfar.dankstorage.utils.SerializationHelper;

public class S2CInitialSyncContainerPacket
implements S2CModPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, S2CInitialSyncContainerPacket> STREAM_CODEC = StreamCodec.ofMember(S2CInitialSyncContainerPacket::write, S2CInitialSyncContainerPacket::new);
    public static final CustomPacketPayload.Type<S2CInitialSyncContainerPacket> TYPE = new CustomPacketPayload.Type(DankPacketHandler.packet(S2CInitialSyncContainerPacket.class));
    private final int windowId;
    private final int stateID;
    private final List<ItemStack> stacks;
    private final ItemStack carried;

    public S2CInitialSyncContainerPacket(int windowId, int stateID, NonNullList<ItemStack> stacks, ItemStack carried) {
        this.windowId = windowId;
        this.stateID = stateID;
        this.stacks = stacks;
        this.carried = carried;
    }

    public S2CInitialSyncContainerPacket(RegistryFriendlyByteBuf buf) {
        this.windowId = buf.readInt();
        this.stateID = buf.readVarInt();
        this.stacks = SerializationHelper.readList(buf);
        this.carried = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
    }

    @Override
    public void handleClient() {
        Player player = CommonClient.getLocalPlayer();
        if (player != null && player.containerMenu instanceof DankMenu && this.windowId == player.containerMenu.containerId) {
            player.containerMenu.initializeContents(this.stateID, this.stacks, this.carried);
        }
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.windowId);
        buf.writeVarInt(this.stateID);
        SerializationHelper.writeList(buf, this.stacks);
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)this.carried);
    }

    public CustomPacketPayload.Type<S2CInitialSyncContainerPacket> type() {
        return TYPE;
    }
}

