/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.menu;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import tfar.dankstorage.init.ModMenuTypes;
import tfar.dankstorage.item.DankItem;
import tfar.dankstorage.menu.DankMenu;

public class ChangeFrequencyMenu
extends AbstractContainerMenu {
    private final ContainerData containerData;
    private final DataSlot currentTier;
    private final ItemStack bag;

    public ChangeFrequencyMenu(int id, Inventory inventory) {
        this(id, inventory, (ContainerData)new SimpleContainerData(2), DataSlot.standalone(), ItemStack.EMPTY);
    }

    public ChangeFrequencyMenu(int $$1, Inventory inventory, ContainerData containerData, DataSlot currentTier, ItemStack bag) {
        super(ModMenuTypes.change_frequency, $$1);
        this.containerData = containerData;
        this.currentTier = currentTier;
        this.bag = bag;
        this.addDataSlots(containerData);
        this.addDataSlot(currentTier);
    }

    public ItemStack quickMoveStack(Player player, int i) {
        return ItemStack.EMPTY;
    }

    public int getFrequency() {
        return DankItem.getFrequency(this.bag);
    }

    public int getTextColor() {
        return this.containerData.get(0);
    }

    public boolean getFreqLock() {
        return this.containerData.get(1) != 0;
    }

    public void toggleFreqLock() {
        boolean b = this.getFreqLock();
        this.containerData.set(1, b ? 0 : 1);
    }

    public int getCurrentTier() {
        return this.currentTier.get();
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void setLinkedFrequency(int frequency) {
        DankItem.setFrequency(this.bag, frequency);
    }

    public boolean clickMenuButton(Player player, int id) {
        if (id < 0 || id >= DankMenu.ButtonAction.VALUES.length) {
            return false;
        }
        DankMenu.ButtonAction buttonAction = DankMenu.ButtonAction.VALUES[id];
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            switch (buttonAction) {
                case LOCK_FREQUENCY: {
                    this.toggleFreqLock();
                }
            }
        }
        return false;
    }
}

