/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import tfar.dankstorage.blockentity.DockBlockEntity;
import tfar.dankstorage.init.ModDataComponentTypes;
import tfar.dankstorage.item.DankItem;
import tfar.dankstorage.utils.CommonUtils;

public class RedprintItem
extends Item {
    public RedprintItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        pTooltipComponents.add((Component)CommonUtils.translatable("text.dankstorage.red_print.tooltip0"));
        pTooltipComponents.add((Component)CommonUtils.translatable("text.dankstorage.red_print.tooltip1"));
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        BlockEntity blockEntity;
        Player player = useOnContext.getPlayer();
        Level level = useOnContext.getLevel();
        BlockPos pos = useOnContext.getClickedPos();
        ItemStack redPrintStack = useOnContext.getItemInHand();
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof DockBlockEntity) {
            DockBlockEntity dockBlockEntity = (DockBlockEntity)blockEntity;
            if (player.isCrouching()) {
                int freq = DankItem.getFrequency(dockBlockEntity.getDank());
                DankItem.setFrequency(redPrintStack, freq);
            } else if (redPrintStack.has(ModDataComponentTypes.FREQUENCY)) {
                dockBlockEntity.setFrequency((Integer)redPrintStack.get(ModDataComponentTypes.FREQUENCY));
            }
        }
        return super.useOn(useOnContext);
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction clickAction, Player player) {
        ItemStack otherStack = slot.getItem();
        if (otherStack.getItem() instanceof DankItem) {
            int redF = DankItem.getFrequency(stack);
            if (redF > -1) {
                DankItem.setFrequency(otherStack, redF);
            }
            return true;
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        int freq;
        if (otherStack.getItem() instanceof DankItem && (freq = DankItem.getFrequency(otherStack)) > -1) {
            DankItem.setFrequency(stack, freq);
            return true;
        }
        return false;
    }

    public Component getName(ItemStack itemStack) {
        MutableComponent component = CommonUtils.literal(super.getName(itemStack).getString());
        return component;
    }
}

