/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.item;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.client.DankKeybinds;
import tfar.dankstorage.client.DankTooltip;
import tfar.dankstorage.init.ModDataComponentTypes;
import tfar.dankstorage.inventory.DankInventory;
import tfar.dankstorage.inventory.LimitedContainerData;
import tfar.dankstorage.inventory.TierDataSlot;
import tfar.dankstorage.menu.ChangeFrequencyMenu;
import tfar.dankstorage.menu.DankMenu;
import tfar.dankstorage.mixin.ItemUsageContextAccessor;
import tfar.dankstorage.network.server.C2SRequestContentsPacket;
import tfar.dankstorage.platform.Services;
import tfar.dankstorage.utils.CommonUtils;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.utils.ItemStackComponent;
import tfar.dankstorage.utils.PickupMode;
import tfar.dankstorage.utils.UseType;
import tfar.dankstorage.world.ClientData;
import tfar.dankstorage.world.DankSavedData;

public class DankItem
extends Item {
    public final DankStats stats;
    static long lastRequest;

    public DankItem(Item.Properties $$0, DankStats stats) {
        super($$0);
        this.stats = stats;
    }

    public void appendHoverText(ItemStack bag, Item.TooltipContext pContext, List<Component> tooltip, TooltipFlag pTooltipFlag) {
        super.appendHoverText(bag, pContext, tooltip, pTooltipFlag);
        int id = DankItem.getFrequency(bag);
        tooltip.add((Component)CommonUtils.literal("ID: " + id));
        if (!Screen.hasShiftDown()) {
            tooltip.add((Component)CommonUtils.translatable("text.dankstorage.shift", CommonUtils.literal("Shift").withStyle(ChatFormatting.YELLOW)).withStyle(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)CommonUtils.translatable("text.dankstorage.change_pickup_mode", DankKeybinds.PICKUP_MODE.getTranslatedKeyMessage().copy().withStyle(ChatFormatting.YELLOW)).withStyle(ChatFormatting.GRAY));
            PickupMode pickupMode = DankItem.getPickupMode(bag);
            tooltip.add((Component)CommonUtils.translatable("text.dankstorage.current_pickup_mode", pickupMode.translate().withStyle(ChatFormatting.YELLOW)).withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)CommonUtils.translatable("text.dankstorage.changeusetype", DankKeybinds.CONSTRUCTION.getTranslatedKeyMessage().copy().withStyle(ChatFormatting.YELLOW)).withStyle(ChatFormatting.GRAY));
            UseType useType = DankItem.getUseType(bag);
            tooltip.add((Component)CommonUtils.translatable("text.dankstorage.currentusetype", CommonUtils.translatable("dankstorage.usetype." + useType.name().toLowerCase(Locale.ROOT)).withStyle(ChatFormatting.YELLOW)).withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)CommonUtils.translatable("text.dankstorage.stacklimit", CommonUtils.literal("" + this.stats.stacklimit).withStyle(ChatFormatting.GREEN)).withStyle(ChatFormatting.GRAY));
        }
        if (Services.PLATFORM.isDevelopmentEnvironment()) {
            this.appendDevOnly(bag, pContext, tooltip, pTooltipFlag);
        }
    }

    protected void appendDevOnly(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
    }

    public InteractionResult interactLivingEntity(ItemStack bag, Player player, LivingEntity entity, InteractionHand hand) {
        if (!DankItem.isConstruction(bag)) {
            return InteractionResult.PASS;
        }
        ItemStack toUse = DankItem.getSelectedItem(bag);
        if (toUse.isEmpty()) {
            return InteractionResult.PASS;
        }
        player.setItemInHand(hand, toUse);
        InteractionResult result = toUse.getItem().interactLivingEntity(toUse, player, entity, hand);
        if (!player.level().isClientSide) {
            DankInventory dankInventory = DankItem.getInventoryFrom(bag, player.getServer());
        }
        player.setItemInHand(hand, bag);
        return result;
    }

    public boolean canBeHurtBy(DamageSource source) {
        return !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY);
    }

    public boolean isFoil(ItemStack stack) {
        return DankItem.getPickupMode(stack) != PickupMode.none;
    }

    public MenuProvider createProvider(final ItemStack stack) {
        return new MenuProvider(){

            public Component getDisplayName() {
                return stack.getHoverName();
            }

            public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player player) {
                DankInventory dankInventory;
                int type;
                int defaults;
                MinecraftServer server = player.getServer();
                if (DankItem.getFrequency(stack) == -1) {
                    DankItem.assignNextFreeId(server, stack);
                    DankSavedData tankSavedData = DankSavedData.getOrCreate(DankItem.getFrequency(stack), server);
                    tankSavedData.setStats(DankItem.this.stats);
                }
                if ((defaults = DankItem.this.stats.slots) != (type = (dankInventory = DankItem.getInventoryFrom(stack, player.getServer())).slotCount())) {
                    if (defaults < type) {
                        return new ChangeFrequencyMenu(i, playerInventory, new LimitedContainerData(dankInventory, 3), new TierDataSlot(DankItem.this.stats), stack);
                    }
                    dankInventory.upgradeTo(DankItem.this.stats);
                }
                return switch (DankItem.this.stats) {
                    default -> DankMenu.t1s(i, playerInventory, dankInventory, stack);
                    case DankStats.two -> DankMenu.t2s(i, playerInventory, dankInventory, stack);
                    case DankStats.three -> DankMenu.t3s(i, playerInventory, dankInventory, stack);
                    case DankStats.four -> DankMenu.t4s(i, playerInventory, dankInventory, stack);
                    case DankStats.five -> DankMenu.t5s(i, playerInventory, dankInventory, stack);
                    case DankStats.six -> DankMenu.t6s(i, playerInventory, dankInventory, stack);
                    case DankStats.seven -> DankMenu.t7s(i, playerInventory, dankInventory, stack);
                };
            }
        };
    }

    public int getGlintColor(ItemStack stack) {
        PickupMode pickupMode = DankItem.getPickupMode(stack);
        switch (pickupMode) {
            default: {
                return -1;
            }
            case pickup_all: {
                return -16711936;
            }
            case filtered_pickup: {
                return -256;
            }
            case void_pickup: 
        }
        return -65536;
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext ctx) {
        ItemStack bag = ctx.getItemInHand();
        Level level = ctx.getLevel();
        UseType useType = DankItem.getUseType(bag);
        if (useType == UseType.bag) {
            return InteractionResult.PASS;
        }
        ItemStack selected = DankItem.getSelectedItem(bag);
        if (selected.isEmpty()) {
            return InteractionResult.PASS;
        }
        ItemStack toPlace = DankItem.getSelectedItem(bag);
        UseOnContext2 ctx2 = new UseOnContext2(ctx.getLevel(), ctx.getPlayer(), ctx.getHand(), toPlace.copy(), ((ItemUsageContextAccessor)ctx).getHitResult());
        InteractionResult actionResultType = toPlace.getItem().useOn((UseOnContext)ctx2);
        if (!level.isClientSide) {
            DankInventory dankInventory = DankItem.getInventoryFrom(bag, level.getServer());
            int consumed = toPlace.getCount() - ctx2.getItemInHand().getCount();
            dankInventory.extractStackTarget(consumed, false, toPlace);
        }
        return actionResultType;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack bag = player.getItemInHand(hand);
        if (DankItem.getUseType(bag) == UseType.bag) {
            if (!level.isClientSide) {
                player.openMenu(this.createProvider(bag));
            }
            return InteractionResultHolder.success((Object)bag);
        }
        if (!level.isClientSide) {
            EquipmentSlot hand1;
            ItemStack toPlace = DankItem.getSelectedItem(bag);
            EquipmentSlot equipmentSlot = hand1 = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            if (toPlace.isEmpty()) {
                return InteractionResultHolder.pass((Object)bag);
            }
            ItemStack bagCopy = bag.copy();
            player.setItemSlot(hand1, toPlace);
            InteractionResultHolder actionResult = toPlace.getItem().use(level, player, hand);
            DankInventory handler = DankItem.getInventoryFrom(bagCopy, level.getServer());
            handler.extractStackTarget(toPlace.getCount() - ((ItemStack)actionResult.getObject()).getCount(), false, toPlace);
            player.setItemSlot(hand1, bagCopy);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.getItemInHand(hand));
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack itemStack) {
        int id = DankItem.getFrequency(itemStack);
        if (id > -1) {
            if (Util.getMillis() - lastRequest > 50L) {
                C2SRequestContentsPacket.send(id);
                lastRequest = Util.getMillis();
            }
            if (ClientData.cachedItems != null) {
                NonNullList nonNullList = NonNullList.create();
                nonNullList.addAll(ClientData.cachedItems);
                return Optional.of(new DankTooltip((NonNullList<ItemStack>)nonNullList, DankItem.getSelectedItem(itemStack)));
            }
        }
        return Optional.empty();
    }

    public static void assignNextFreeId(MinecraftServer server, ItemStack stack) {
        int id = DankStorage.firstFreeId(server);
        if (id > -1) {
            stack.set(ModDataComponentTypes.FREQUENCY, (Object)id);
        } else {
            stack.set(ModDataComponentTypes.FREQUENCY, (Object)(DankStorage.MAX - 1));
        }
    }

    public void inventoryTick(ItemStack bag, Level level, Entity entity, int i, boolean equipped) {
        if (entity instanceof ServerPlayer) {
            long amount;
            DankInventory dankInventory;
            ServerPlayer player = (ServerPlayer)entity;
            ItemStack sel = DankItem.getSelectedItem(bag);
            if (!sel.isEmpty() && (dankInventory = DankItem.getInventoryFrom(bag, player.server)) != null && (amount = dankInventory.countItem(sel)) != (long)sel.getCount()) {
                DankItem.setSelectedItem(bag, sel.copyWithCount((int)amount));
            }
        }
    }

    public static void setSelectedItem(ItemStack bag, ItemStack item) {
        if (item.isEmpty()) {
            bag.remove(ModDataComponentTypes.SELECTED);
        } else {
            bag.set(ModDataComponentTypes.SELECTED, (Object)new ItemStackComponent(item));
        }
    }

    public static ItemStack getSelectedItem(ItemStack bag) {
        return ((ItemStackComponent)bag.getOrDefault(ModDataComponentTypes.SELECTED, (Object)ItemStackComponent.EMPTY)).itemStack();
    }

    public static void setFrequency(ItemStack bag, int frequency) {
        if (frequency < 0) {
            bag.remove(ModDataComponentTypes.FREQUENCY);
        } else {
            bag.set(ModDataComponentTypes.FREQUENCY, (Object)frequency);
        }
    }

    public static int getFrequency(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponentTypes.FREQUENCY, (Object)-1);
    }

    public static DankInventory getInventoryFrom(ItemStack bag, MinecraftServer server) {
        int frequency = DankItem.getFrequency(bag);
        if (frequency < 0) {
            return null;
        }
        return DankSavedData.get(frequency, server).getOrCreateInventory();
    }

    public static void changeSelectedItem(ItemStack mainHandItem, boolean right, ServerPlayer player) {
        List<ItemStack> gathered;
        DankInventory dankInventory = DankItem.getInventoryFrom(mainHandItem, player.server);
        ItemStack current = DankItem.getSelectedItem(mainHandItem);
        if (dankInventory != null && !(gathered = dankInventory.getUniqueItems()).isEmpty()) {
            int index = -1;
            for (int i = 0; i < gathered.size(); ++i) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)current, (ItemStack)gathered.get(i))) continue;
                index = i;
                break;
            }
            if (index > -1) {
                int next = -1;
                next = right ? index + 1 : index - 1;
                if (next >= gathered.size()) {
                    next = 0;
                }
                if (next == -1) {
                    next = gathered.size() - 1;
                }
                DankItem.setSelectedItem(mainHandItem, gathered.get(next));
            } else {
                DankItem.setSelectedItem(mainHandItem, gathered.getFirst());
            }
        }
    }

    public static PickupMode getPickupMode(ItemStack bag) {
        return (PickupMode)((Object)bag.getOrDefault(ModDataComponentTypes.PICKUP_MODE, (Object)PickupMode.none));
    }

    public static void setPickupMode(ItemStack bag, PickupMode mode) {
        bag.set(ModDataComponentTypes.PICKUP_MODE, (Object)mode);
    }

    public static boolean isConstruction(ItemStack bag) {
        return DankItem.getUseType(bag) == UseType.construction;
    }

    public static void cyclePickupMode(ItemStack bag, Player player) {
        PickupMode mode = DankItem.getPickupMode(bag);
        PickupMode cycle = DankItem.cycle(mode);
        DankItem.setPickupMode(bag, cycle);
        player.displayClientMessage((Component)CommonUtils.translatable("dankstorage.mode." + String.valueOf((Object)mode)), true);
    }

    public static UseType getUseType(ItemStack bag) {
        return (UseType)((Object)bag.getOrDefault(ModDataComponentTypes.USE_TYPE, (Object)UseType.bag));
    }

    public static void cyclePlacement(ItemStack bag, Player player) {
        UseType useType = DankItem.getUseType(bag);
        UseType cycle = DankItem.cycle(useType);
        DankItem.setUseType(bag, cycle);
        player.displayClientMessage((Component)CommonUtils.translatable("dankstorage.usetype." + String.valueOf((Object)cycle)), true);
    }

    public static void setUseType(ItemStack bag, UseType useType) {
        bag.set(ModDataComponentTypes.USE_TYPE, (Object)useType);
    }

    public static <E extends Enum<E>> E cycle(E e) {
        Enum[] values = (Enum[])e.getClass().getEnumConstants();
        return (E)values[(e.ordinal() + 1) % values.length];
    }

    static class UseOnContext2
    extends UseOnContext {
        protected UseOnContext2(Level $$0, @Nullable Player $$1, InteractionHand $$2, ItemStack $$3, BlockHitResult $$4) {
            super($$0, $$1, $$2, $$3, $$4);
        }
    }
}

