/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.events;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.inventory.DankInventory;
import tfar.dankstorage.item.DankItem;
import tfar.dankstorage.utils.CommonUtils;
import tfar.dankstorage.utils.PickupMode;

public class CommonEvents {
    public static boolean interceptItem(Inventory inv, ItemStack incoming) {
        Player player = inv.player;
        if (player.level().isClientSide || incoming.isEmpty()) {
            return false;
        }
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack possibleDank = inv.getItem(i);
            if (!(possibleDank.getItem() instanceof DankItem) || !CommonEvents.onItemPickup(player, incoming, possibleDank)) continue;
            return true;
        }
        return false;
    }

    public static boolean onItemPickup(Player player, ItemStack pickup, ItemStack dank) {
        int i;
        PickupMode pickupMode = DankItem.getPickupMode(dank);
        if (pickupMode == PickupMode.none) {
            return false;
        }
        DankInventory inv = DankItem.getInventoryFrom(dank, player.getServer());
        if (inv == null) {
            DankStorage.LOG.warn("That's odd, the player somehow got an unassigned dank to change pickup mode");
            return false;
        }
        int count = pickup.getCount();
        boolean oredict = CommonUtils.oredict(dank);
        ArrayList<ItemStack> existing = new ArrayList<ItemStack>();
        for (i = 0; i < inv.slotCount(); ++i) {
            ItemStack stack = inv.getItemDank(i);
            if (stack.isEmpty()) continue;
            boolean exists = false;
            for (ItemStack stack1 : existing) {
                if (!CommonEvents.areItemStacksCompatible(stack, stack1, oredict)) continue;
                exists = true;
            }
            if (exists) continue;
            existing.add(stack.copy());
        }
        block0 : switch (pickupMode) {
            case pickup_all: {
                for (i = 0; i < inv.slotCount(); ++i) {
                    CommonEvents.allPickup(inv, i, pickup, oredict);
                    if (pickup.isEmpty()) break block0;
                }
                break;
            }
            case filtered_pickup: {
                for (i = 0; i < inv.slotCount(); ++i) {
                    CommonEvents.filteredPickup(inv, i, pickup, oredict, existing);
                    if (pickup.isEmpty()) break block0;
                }
                break;
            }
            case void_pickup: {
                for (i = 0; i < inv.slotCount(); ++i) {
                    CommonEvents.voidPickup(inv, i, pickup, oredict, existing);
                    if (pickup.isEmpty()) break block0;
                }
                break;
            }
        }
        if (pickup.getCount() != count) {
            dank.setPopTime(5);
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        return pickup.isEmpty();
    }

    public static void voidPickup(DankInventory inv, int slot, ItemStack toInsert, boolean oredict, List<ItemStack> filter) {
        ItemStack existing = inv.getItemDank(slot);
        if (CommonEvents.doesItemStackExist(toInsert, filter, oredict) && CommonEvents.areItemStacksCompatible(existing, toInsert, oredict)) {
            int stackLimit = inv.capacity;
            int total = Math.min(toInsert.getCount() + existing.getCount(), stackLimit);
            inv.setItemDank(slot, existing.copyWithCount(total));
            toInsert.setCount(0);
        }
    }

    public static void allPickup(DankInventory inv, int slot, ItemStack pickup, boolean oredict) {
        ItemStack existing = inv.getItemDank(slot);
        if (existing.isEmpty()) {
            int stackLimit = inv.capacity;
            int total = pickup.getCount();
            int remainder = total - stackLimit;
            if (remainder <= 0) {
                inv.setItemDank(slot, pickup.copy());
                pickup.setCount(0);
            } else {
                inv.setItemDank(slot, pickup.copyWithCount(stackLimit));
                pickup.setCount(remainder);
            }
            return;
        }
        if (ItemStack.isSameItemSameComponents((ItemStack)pickup, (ItemStack)existing) || oredict) {
            int stackLimit = inv.capacity;
            int total = pickup.getCount() + existing.getCount();
            int remainder = total - stackLimit;
            if (remainder <= 0) {
                inv.setItemDank(slot, existing.copyWithCount(total));
                pickup.setCount(0);
            } else {
                inv.setItemDank(slot, pickup.copyWithCount(stackLimit));
                pickup.setCount(remainder);
            }
        }
    }

    public static void filteredPickup(DankInventory inv, int slot, ItemStack toInsert, boolean oredict, List<ItemStack> filter) {
        ItemStack existing = inv.getItemDank(slot);
        if (existing.isEmpty() && CommonEvents.doesItemStackExist(toInsert, filter, oredict)) {
            int stackLimit = inv.capacity;
            int total = toInsert.getCount();
            int remainder = total - stackLimit;
            if (remainder <= 0) {
                inv.setItemDank(slot, toInsert.copy());
                toInsert.setCount(0);
            } else {
                inv.setItemDank(slot, toInsert.copyWithCount(stackLimit));
                toInsert.setCount(remainder);
            }
            return;
        }
        if (CommonEvents.doesItemStackExist(toInsert, filter, oredict) && CommonEvents.areItemStacksCompatible(existing, toInsert, oredict)) {
            int stackLimit = inv.capacity;
            int total = toInsert.getCount() + existing.getCount();
            int remainder = total - stackLimit;
            if (remainder <= 0) {
                inv.setItemDank(slot, existing.copyWithCount(total));
                toInsert.setCount(0);
            } else {
                inv.setItemDank(slot, toInsert.copyWithCount(stackLimit));
                toInsert.setCount(remainder);
            }
        }
    }

    public static boolean areItemStacksCompatible(ItemStack stackA, ItemStack stackB, boolean oredict) {
        return oredict ? ItemStack.isSameItemSameComponents((ItemStack)stackA, (ItemStack)stackB) : ItemStack.isSameItemSameComponents((ItemStack)stackA, (ItemStack)stackB);
    }

    public static boolean doesItemStackExist(ItemStack stack, List<ItemStack> filter, boolean oredict) {
        for (ItemStack filterStack : filter) {
            if (!CommonEvents.areItemStacksCompatible(stack, filterStack, oredict)) continue;
            return true;
        }
        return false;
    }
}

