/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import tfar.dankstorage.item.DankItem;
import tfar.dankstorage.utils.CommonUtils;
import tfar.dankstorage.world.DankSavedData;

public class DankCommands {
    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"dankstorage").then(((LiteralArgumentBuilder)Commands.literal((String)"clear").requires(commandSourceStack -> commandSourceStack.hasPermission(3))).then(Commands.argument((String)"frequency", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(DankCommands::clearID))));
    }

    private static int clearAll(CommandContext<CommandSourceStack> context) {
        return 1;
    }

    private static int clearID(CommandContext<CommandSourceStack> context) {
        int id = IntegerArgumentType.getInteger(context, (String)"frequency");
        boolean success = false;
        DankSavedData data = DankSavedData.get(id, ((CommandSourceStack)context.getSource()).getServer());
        if (data != null) {
            data.getOrCreateInventory().clear();
            success = true;
        }
        if (!success) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)CommonUtils.translatable("dankstorage.command.clear_id.invalid_id"));
        }
        return 1;
    }

    private static int setTier(CommandContext<CommandSourceStack> context) {
        int id = IntegerArgumentType.getInteger(context, (String)"frequency");
        int tier = IntegerArgumentType.getInteger(context, (String)"tier");
        boolean success = false;
        if (!success) {
            // empty if block
        }
        return 1;
    }

    private static int resetFrequency(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack sourceStack = (CommandSourceStack)context.getSource();
        ServerPlayer player = sourceStack.getPlayerOrException();
        ItemStack dank = player.getMainHandItem();
        if (dank.getItem() instanceof DankItem) {
            return 1;
        }
        return 0;
    }

    private static int lock(CommandContext<CommandSourceStack> context) {
        int id = IntegerArgumentType.getInteger(context, (String)"frequency");
        boolean success = false;
        if (!success) {
            // empty if block
        }
        return 1;
    }

    private static int unlock(CommandContext<CommandSourceStack> context) {
        int id = IntegerArgumentType.getInteger(context, (String)"frequency");
        boolean success = false;
        if (!success) {
            // empty if block
        }
        return 1;
    }
}

