/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.client;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class DynamicTooltip
extends Tooltip {
    public boolean dirty = true;
    public Supplier<Component> messageSupplier;
    public Supplier<Component> narrationSupplier;
    public Component lastMessage;
    public Component lastNarration;

    public DynamicTooltip(Supplier<Component> messageSupplier, Supplier<Component> narrationSupplier) {
        super(null, null);
        this.messageSupplier = messageSupplier;
        this.narrationSupplier = narrationSupplier;
    }

    public static DynamicTooltip dynamic(Supplier<Component> componentSupplier) {
        return new DynamicTooltip(componentSupplier, componentSupplier);
    }

    public List<FormattedCharSequence> toCharSequence(Minecraft $$0) {
        if (this.dirty && !Objects.equals(this.lastMessage, this.messageSupplier.get())) {
            this.lastMessage = this.messageSupplier.get();
            this.lastNarration = this.narrationSupplier.get();
            this.cachedTooltip = null;
            this.dirty = false;
        }
        if (this.cachedTooltip == null) {
            this.cachedTooltip = DynamicTooltip.splitTooltip((Minecraft)$$0, (Component)this.lastMessage);
        }
        return this.cachedTooltip;
    }

    public void updateNarration(NarrationElementOutput $$0) {
        if (this.lastNarration != null) {
            $$0.add(NarratedElementType.HINT, this.lastNarration);
        }
    }
}

