/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.client;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import tfar.dankstorage.client.DankTooltip;
import tfar.dankstorage.client.StackSizeRenderer;
import tfar.dankstorage.platform.Services;
import tfar.dankstorage.utils.CommonUtils;

public class ClientDankTooltip
implements ClientTooltipComponent {
    private static final int MARGIN_Y = 4;
    private static final int BORDER_WIDTH = 1;
    private static final int TEX_SIZE = 128;
    private static final int SLOT_SIZE_X = 18;
    private static final int SLOT_SIZE_Y = 18;
    private final NonNullList<ItemStack> items;
    private final ItemStack selected;

    public ClientDankTooltip(DankTooltip bundleTooltip) {
        this.items = bundleTooltip.getItems();
        this.selected = bundleTooltip.getSelected();
    }

    public int getHeight() {
        return this.gridSizeY() * 18 + 4;
    }

    public int getWidth(Font font) {
        return this.gridSizeX() * 18;
    }

    public void renderImage(Font font, int i, int j, GuiGraphics poseStack) {
        int gridSizeX = this.gridSizeX();
        int gridSizeY = this.gridSizeY();
        int slot = 0;
        for (int y1 = 0; y1 < gridSizeY; ++y1) {
            for (int x1 = 0; x1 < gridSizeX; ++x1) {
                int q = i + x1 * 18;
                int r = j + y1 * 18;
                this.renderSlot(q, r, slot++, font, poseStack);
            }
        }
    }

    private void renderSlot(int i, int j, int slot, Font font, GuiGraphics poseStack) {
        ItemStack itemStack = (ItemStack)this.items.get(slot);
        this.blit(poseStack, i, j, Texture.SLOT);
        poseStack.renderItem(itemStack, i + 1, j + 1, slot);
        int count = itemStack.getCount();
        if (count > 1) {
            StackSizeRenderer.renderSizeLabelCustom(poseStack, font, (float)(i + 1), (float)(j + 1), CommonUtils.formatLargeNumber(count), Services.PLATFORM.getConfig().textSize());
        }
        if (!this.selected.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)this.selected, (ItemStack)itemStack)) {
            AbstractContainerScreen.renderSlotHighlight((GuiGraphics)poseStack, (int)(i + 1), (int)(j + 1), (int)0);
        }
    }

    private void blit(GuiGraphics guiGraphics, int x, int y, Texture texture) {
        guiGraphics.blitSprite(texture.sprite, x, y, 0, texture.w, texture.h);
    }

    private int gridSizeX() {
        return 9;
    }

    private int gridSizeY() {
        return this.items.size() / this.gridSizeX();
    }

    private static enum Texture {
        BLOCKED_SLOT(ResourceLocation.withDefaultNamespace((String)"container/bundle/blocked_slot"), 18, 20),
        SLOT(ResourceLocation.withDefaultNamespace((String)"container/bundle/slot"), 18, 20);

        public final ResourceLocation sprite;
        public final int w;
        public final int h;

        private Texture(ResourceLocation sprite, int w, int h) {
            this.sprite = sprite;
            this.w = w;
            this.h = h;
        }
    }
}

