/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import tfar.dankstorage.ModTags;
import tfar.dankstorage.blockentity.DockBlockEntity;
import tfar.dankstorage.item.DankItem;

public class DockBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty TIER = IntegerProperty.create((String)"tier", (int)0, (int)7);
    public static final VoxelShape EMPTY;
    public static final VoxelShape DOCKED;

    public DockBlock(BlockBehaviour.Properties $$0) {
        super($$0);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Integer)state.getValue((Property)TIER) > 0 ? DOCKED : EMPTY;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new DockBlockEntity(blockPos, blockState);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        ItemStack bag = ctx.getItemInHand();
        Block block = Block.byItem((Item)bag.getItem());
        if (block instanceof DockBlock) {
            return block.defaultBlockState();
        }
        return block.getStateForPlacement(ctx);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TIER});
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pos, Player player, InteractionHand hand, BlockHitResult pHitResult) {
        BlockEntity tile;
        if (!pLevel.isClientSide && (tile = pLevel.getBlockEntity(pos)) instanceof DockBlockEntity) {
            DockBlockEntity dockBlockEntity = (DockBlockEntity)tile;
            ItemStack held = player.getItemInHand(hand);
            if (player.isCrouching() && held.is(ModTags.WRENCHES)) {
                pLevel.destroyBlock(pos, true, (Entity)player);
                return ItemInteractionResult.SUCCESS;
            }
            if (held.getItem() instanceof DankItem) {
                if ((Integer)pState.getValue((Property)TIER) > 0) {
                    dockBlockEntity.giveToPlayer(player);
                }
                dockBlockEntity.addDank(held);
                return ItemInteractionResult.SUCCESS;
            }
            if (player.isShiftKeyDown() && (Integer)pState.getValue((Property)TIER) > 0) {
                dockBlockEntity.giveToPlayer(player);
                return ItemInteractionResult.SUCCESS;
            }
            player.openMenu((MenuProvider)tile);
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level pLevel, BlockPos pos, Player player, BlockHitResult pHitResult) {
        BlockEntity tile;
        if (!pLevel.isClientSide && (tile = pLevel.getBlockEntity(pos)) instanceof DockBlockEntity) {
            DockBlockEntity dockBlockEntity = (DockBlockEntity)tile;
            if (player.isShiftKeyDown() && (Integer)state.getValue((Property)TIER) > 0) {
                dockBlockEntity.giveToPlayer(player);
                return InteractionResult.SUCCESS;
            }
            player.openMenu((MenuProvider)tile);
        }
        return InteractionResult.SUCCESS;
    }

    static {
        VoxelShape a1 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
        VoxelShape b1 = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
        VoxelShape bottom_ring = Shapes.joinUnoptimized((VoxelShape)a1, (VoxelShape)b1, (BooleanOp)BooleanOp.NOT_SAME);
        VoxelShape a2 = Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape b2 = Block.box((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape top_ring = Shapes.joinUnoptimized((VoxelShape)a2, (VoxelShape)b2, (BooleanOp)BooleanOp.NOT_SAME);
        VoxelShape p1 = Block.box((double)0.0, (double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0);
        VoxelShape p2 = Block.box((double)12.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)4.0);
        VoxelShape p3 = Block.box((double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0);
        VoxelShape p4 = Block.box((double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0, (double)16.0);
        EMPTY = Shapes.or((VoxelShape)bottom_ring, (VoxelShape[])new VoxelShape[]{top_ring, p1, p2, p3, p4});
        DOCKED = Shapes.or((VoxelShape)EMPTY, (VoxelShape)Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0));
    }
}

