/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage;

import java.io.File;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tfar.dankstorage.init.ModBlockEntityTypes;
import tfar.dankstorage.init.ModBlocks;
import tfar.dankstorage.init.ModCreativeTabs;
import tfar.dankstorage.init.ModDataComponentTypes;
import tfar.dankstorage.init.ModItems;
import tfar.dankstorage.init.ModMenuTypes;
import tfar.dankstorage.init.ModRecipeSerializers;
import tfar.dankstorage.mixin.MinecraftServerAccess;
import tfar.dankstorage.platform.Services;
import tfar.dankstorage.utils.CommonUtils;
import tfar.dankstorage.world.DankSavedData;
import tfar.dankstorage.world.MaxId;

public class DankStorage {
    public static final String MODID = "dankstorage";
    public static final String MOD_NAME = "Dank-Storage";
    public static final Logger LOG = LoggerFactory.getLogger((String)"Dank-Storage");
    public static int MAX = 1000000000;

    public static int firstFreeId(MinecraftServer server) {
        for (int id = 0; id < MAX; ++id) {
            DankSavedData tankSavedData = DankSavedData.get(id, server);
            if (tankSavedData != null) continue;
            return id;
        }
        return -1;
    }

    public static void init() {
        Services.PLATFORM.registerAll(ModBlocks.class, BuiltInRegistries.BLOCK, Block.class);
        Class<BlockEntityType> typeClass = BlockEntityType.class;
        Class<MenuType> typeClass1 = MenuType.class;
        Class<RecipeSerializer> typeClass2 = RecipeSerializer.class;
        Class<DataComponentType> typeClass3 = DataComponentType.class;
        Services.PLATFORM.registerAll(ModBlockEntityTypes.class, BuiltInRegistries.BLOCK_ENTITY_TYPE, typeClass);
        Services.PLATFORM.unfreeze(BuiltInRegistries.ITEM);
        Services.PLATFORM.registerAll(ModItems.getAll(), BuiltInRegistries.ITEM, Item.class);
        Services.PLATFORM.registerAll(ModCreativeTabs.class, BuiltInRegistries.CREATIVE_MODE_TAB, CreativeModeTab.class);
        Services.PLATFORM.registerAll(ModMenuTypes.class, BuiltInRegistries.MENU, typeClass1);
        Services.PLATFORM.registerAll(ModRecipeSerializers.class, BuiltInRegistries.RECIPE_SERIALIZER, typeClass2);
        Services.PLATFORM.registerAll(ModDataComponentTypes.class, BuiltInRegistries.DATA_COMPONENT_TYPE, typeClass3);
    }

    public static MaxId getMaxId(MinecraftServer server) {
        return (MaxId)server.overworld().getDataStorage().computeIfAbsent(MaxId.factory(server.overworld()), "dankstorage_max_id");
    }

    public static void onServerShutDown(MinecraftServer server) {
        CommonUtils.uncacheRecipes();
    }

    public static void onServerStart(MinecraftServer server) {
        LevelStorageSource.LevelStorageAccess storageSource = ((MinecraftServerAccess)server).getStorageSource();
        File file = storageSource.getDimensionPath(server.overworld().dimension()).resolve("data/dankstorage").toFile();
        file.mkdirs();
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }
}

