/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import divinerpg.registries.PlacementModifierRegistry;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class Surface
extends PlacementModifier {
    public static final MapCodec<Surface> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("surface").forGetter(config -> config.surface), (App)Codec.STRING.optionalFieldOf("mode", (Object)"full").forGetter(config -> config.mode), (App)Codec.INT.fieldOf("min_height").forGetter(config -> config.minHeight), (App)Codec.INT.fieldOf("max_height").forGetter(config -> config.maxHeight), (App)Codec.INT.fieldOf("bury").forGetter(config -> config.maxHeight)).apply((Applicative)instance, Surface::new));
    public final String surface;
    public final String mode;
    public final int minHeight;
    public final int maxHeight;
    public final int bury;

    public Surface(String surface, String mode, int minHeight, int maxHeight, int bury) {
        this.surface = surface;
        this.mode = mode;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.bury = bury;
    }

    public static int getSurface(Surface_Type type, Mode mode, int minHeight, int maxHeight, int bury, WorldGenLevel level, RandomSource random, int x, int z) {
        int maxY;
        int minY;
        if (mode == Mode.RANDOM_SECTION) {
            minY = random.nextInt(minHeight, maxHeight + 1);
            maxY = random.nextInt(minY, maxHeight + 1);
        } else {
            minY = minHeight;
            maxY = maxHeight;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, mode == Mode.SLICE ? random.nextInt(minY, maxY + 1) : (type == Surface_Type.LOWEST_CEILING || type == Surface_Type.LOWEST_GROUND ? minY : maxY), z);
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (Surface.hasSpace(level, (BlockPos)pos)) {
                    do {
                        pos.move(Direction.DOWN);
                    } while (pos.getY() > minY - 2 && Surface.hasSpace(level, (BlockPos)pos));
                }
                while (pos.getY() > minY - 2 && !Surface.hasSpace(level, (BlockPos)pos)) {
                    pos.move(Direction.DOWN);
                }
                yield pos.getY() + bury;
            }
            case 1 -> {
                if (!Surface.hasSpace(level, (BlockPos)pos)) {
                    do {
                        pos.move(Direction.DOWN);
                    } while (pos.getY() > minY - 2 && !Surface.hasSpace(level, (BlockPos)pos));
                }
                while (pos.getY() > minY - 2 && Surface.hasSpace(level, (BlockPos)pos)) {
                    pos.move(Direction.DOWN);
                }
                yield pos.getY() - bury + 1;
            }
            case 2 -> {
                if (!Surface.hasSpace(level, (BlockPos)pos)) {
                    do {
                        pos.move(Direction.UP);
                    } while (pos.getY() < maxY + 2 && !Surface.hasSpace(level, (BlockPos)pos));
                }
                while (pos.getY() < maxY + 2 && Surface.hasSpace(level, (BlockPos)pos)) {
                    pos.move(Direction.UP);
                }
                yield pos.getY() + bury - 1;
            }
            case 3 -> {
                if (Surface.hasSpace(level, (BlockPos)pos)) {
                    do {
                        pos.move(Direction.UP);
                    } while (pos.getY() < maxY + 2 && Surface.hasSpace(level, (BlockPos)pos));
                }
                while (pos.getY() < maxY + 2 && !Surface.hasSpace(level, (BlockPos)pos)) {
                    pos.move(Direction.UP);
                }
                yield pos.getY() - bury;
            }
        };
    }

    public static boolean hasSpace(BlockState state) {
        return state.isAir() || state.is(Blocks.WATER);
    }

    public static boolean hasSpace(WorldGenLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return state.isAir() || state.is(Blocks.WATER);
    }

    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        int y;
        int maxY;
        int minY;
        Mode modus = Mode.valueOf(this.mode.toUpperCase());
        if (modus == Mode.RANDOM_SECTION) {
            minY = random.nextInt(this.minHeight, this.maxHeight + 1);
            maxY = random.nextInt(minY, this.maxHeight + 1);
            y = Surface.getSurface(Surface_Type.valueOf(this.surface.toUpperCase()), Mode.FULL, minY, maxY, this.bury, context.getLevel(), random, pos.getX(), pos.getZ());
        } else {
            minY = this.minHeight;
            maxY = this.maxHeight;
            y = Surface.getSurface(Surface_Type.valueOf(this.surface.toUpperCase()), modus, minY, maxY, this.bury, context.getLevel(), random, pos.getX(), pos.getZ());
        }
        if (y > maxY || y < minY) {
            return Stream.of(new BlockPos[0]);
        }
        return Stream.of(pos.atY(y));
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)PlacementModifierRegistry.SURFACE_PLACEMENT.get();
    }

    public static enum Mode {
        FULL,
        RANDOM_SECTION,
        SLICE;

    }

    public static enum Surface_Type {
        HIGHEST_CEILING,
        HIGHEST_GROUND,
        LOWEST_CEILING,
        LOWEST_GROUND;

    }
}

