/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.tree;

import divinerpg.world.feature.config.tree.TreeConfig;
import divinerpg.world.feature.tree.AuroraoakTree;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;

public class StreamleafTree
extends AuroraoakTree {
    @Override
    public boolean canBeHere(WorldGenLevel level, RandomSource random, BlockPos pos, TreeConfig config) {
        return super.canBeHere(level, random, pos, config) && (level.getBlockState(pos.offset(-1, -1, 0)).is(Blocks.WATER) || level.getBlockState(pos.offset(1, -1, 0)).is(Blocks.WATER) || level.getBlockState(pos.offset(0, -1, -1)).is(Blocks.WATER) || level.getBlockState(pos.offset(0, -1, 1)).is(Blocks.WATER));
    }

    @Override
    public boolean place(TreeConfig config, WorldGenLevel level, ChunkGenerator chunkGen, RandomSource random, BlockPos pos) {
        int treeHeight;
        int extraHeight;
        if (this.canBeHere(level, random, pos, config) && this.heightCheck(level, pos, extraHeight = (treeHeight = 3 + random.nextInt(3)) + 1, 1)) {
            this.grow(level, pos, config.log, 1, 0, true);
            this.grow(level, pos.below(), config.log, 1, 0, true);
            this.gradualGrowth(level, random, pos.mutable(), config.log, config.leaves, treeHeight, 0.35f, 0.18f, true);
            return true;
        }
        return false;
    }

    @Override
    protected void growLeaves(WorldGenLevel level, RandomSource random, BlockPos pos, BlockState leaves) {
        this.setBlock(level, pos, leaves, false);
        this.grow(level, pos, leaves, 1, 0);
        pos = pos.below();
        this.grow(level, pos, leaves, 1, 1);
        this.grow(level, pos, leaves, 2, 1);
        this.grow(level, pos, leaves, 2, 0);
        this.grow(level, pos, leaves, 2, -1);
        pos = pos.below();
        this.growHangingLeaves(level, random, pos, leaves, 2, 1);
        this.growHangingLeaves(level, random, pos, leaves, 2, 0);
        this.growHangingLeaves(level, random, pos, leaves, 2, -1);
    }

    protected void hangingLeaves(WorldGenLevel level, RandomSource random, BlockPos.MutableBlockPos pos, BlockState leaves) {
        this.setBlock(level, (BlockPos)pos, leaves, false);
        while (random.nextInt(4) == 0) {
            pos.move(0, -1, 0);
            if (this.hasSpace(level, (BlockPos)pos)) {
                this.setBlock((LevelWriter)level, (BlockPos)pos, leaves);
                continue;
            }
            return;
        }
    }

    protected void growHangingLeaves(WorldGenLevel level, RandomSource random, BlockPos pos, BlockState leaves, int width, int offset) {
        this.hangingLeaves(level, random, pos.offset(width, 0, offset).mutable(), leaves);
        this.hangingLeaves(level, random, pos.offset(-width, 0, -offset).mutable(), leaves);
        this.hangingLeaves(level, random, pos.offset(offset, 0, -width).mutable(), leaves);
        this.hangingLeaves(level, random, pos.offset(-offset, 0, width).mutable(), leaves);
    }
}

