/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.tree;

import divinerpg.registries.BlockRegistry;
import divinerpg.world.feature.config.tree.TreeConfig;
import divinerpg.world.feature.tree.DivineTree;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;

public class EdenTree
extends DivineTree {
    @Override
    protected boolean defaultGrowOn(BlockState state) {
        return state.is((Block)BlockRegistry.edenDirt.get()) || state.is((Block)BlockRegistry.edenGrass.get());
    }

    @Override
    public boolean place(TreeConfig config, WorldGenLevel level, ChunkGenerator chunkGen, RandomSource random, BlockPos pos) {
        if (this.canBeHere(level, random, pos, config)) {
            int extraHeight;
            int treeHeight;
            int treeType = random.nextInt(4);
            switch (treeType) {
                case 0: {
                    treeHeight = 3 + random.nextInt(10);
                    extraHeight = treeHeight + 3 + random.nextInt(2);
                    break;
                }
                case 1: {
                    treeHeight = 1 + random.nextInt(3);
                    extraHeight = treeHeight + 2;
                    break;
                }
                case 2: {
                    treeHeight = 0 + random.nextInt(3);
                    extraHeight = treeHeight + 1;
                    break;
                }
                default: {
                    return super.place(config, level, chunkGen, random, pos);
                }
            }
            if (this.heightCheck(level, pos, extraHeight, 1)) {
                BlockState log = config.log;
                BlockState leaves = config.leaves;
                this.grow(level, pos, log, treeHeight);
                switch (treeType) {
                    case 0: {
                        int bottomHeight = 1;
                        if (treeHeight > 9 || treeHeight == 9 && random.nextBoolean()) {
                            ++bottomHeight;
                            this.grow(level, random, pos, log, 1, 0, 0.5f);
                        }
                        this.grow(level, pos.offset(0, bottomHeight, 0), leaves, treeHeight + 1 - bottomHeight, 1, 0);
                        if (treeHeight > 7) {
                            this.grow(level, pos.offset(0, bottomHeight + 2, 0), leaves, treeHeight - 5 - bottomHeight, 2, 0);
                            this.grow(level, random, pos.offset(0, treeHeight - 2, 0), leaves, 2, 0, 0.5f);
                            this.grow(level, pos.offset(0, bottomHeight + 1, 0), leaves, treeHeight - 3 - bottomHeight, 1, 1);
                            this.grow(level, random, pos.offset(0, treeHeight - 1, 0), leaves, 1, 1, 0.5f);
                        } else {
                            if (treeHeight - 2 >= bottomHeight + 2) {
                                this.grow(level, pos.offset(0, bottomHeight + 2, 0), leaves, treeHeight - 4 - bottomHeight, 2, 0);
                            }
                            this.grow(level, pos.offset(0, bottomHeight + 1, 0), leaves, treeHeight - 2 - bottomHeight, 1, 1);
                            if (treeHeight < 7) {
                                this.grow(level, random, pos.offset(0, treeHeight, 0), leaves, 1, 1, 0.5f);
                            }
                            if (treeHeight != 3 && treeHeight < 7) {
                                this.grow(level, random, pos.offset(0, bottomHeight + 1, 0), leaves, 2, 0, 0.5f);
                                if (treeHeight < 6) {
                                    this.grow(level, random, pos.offset(0, treeHeight - 1, 0), leaves, 2, 0, 0.5f);
                                }
                            }
                        }
                        this.grow(level, pos.offset(0, treeHeight + 1, 0), leaves, extraHeight - 1 - treeHeight);
                        break;
                    }
                    case 1: {
                        this.setBlock(level, pos.offset(0, -1, 0), log, true);
                        this.grow(level, pos.below(), log, 1, 0, true);
                        this.grow(level, random, pos, log, 1, 0, 0.25f);
                        this.setBlock((LevelWriter)level, pos.offset(0, treeHeight + 1, 0), leaves);
                        this.chanceSetBlock(level, random, pos.offset(0, extraHeight, 0), leaves, 0.5f);
                        this.grow(level, pos.offset(0, treeHeight - 1, 0), leaves, 2, 1, 0);
                        this.grow(level, random, pos.offset(0, treeHeight - 1, 0), leaves, 1, 1, 0.25f);
                        this.grow(level, pos.offset(0, treeHeight, 0), leaves, 1, 1);
                        this.grow(level, random, pos.offset(0, treeHeight, 0), leaves, 2, 0, 0.5f);
                        break;
                    }
                    default: {
                        this.setBlock((LevelWriter)level, pos.offset(0, extraHeight, 0), leaves);
                        this.grow(level, pos.offset(0, treeHeight, 0), leaves, 1, 0);
                    }
                }
                return true;
            }
        }
        return false;
    }
}

