/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.tree;

import divinerpg.world.feature.config.tree.TreeConfig;
import divinerpg.world.feature.decoration.SnowCoverage;
import divinerpg.world.feature.tree.ShiverspineTree;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;

public class CozybarkTree
extends ShiverspineTree {
    @Override
    protected void setBlock(WorldGenLevel level, BlockPos pos, BlockState state, boolean replace) {
        BlockPos.MutableBlockPos position = pos.mutable();
        BlockState s = level.getBlockState(pos);
        boolean hasSnow = s.is(BlockTags.SNOW);
        if (hasSnow) {
            this.setBlock((LevelWriter)level, pos, state.hasProperty((Property)BlockStateProperties.SNOWY) ? (BlockState)state.setValue((Property)BlockStateProperties.SNOWY, (Comparable)Boolean.valueOf(true)) : state);
            while (level.getBlockState((BlockPos)position.move(0, 1, 0)).is(BlockTags.SNOW)) {
                this.setBlock((LevelWriter)level, (BlockPos)position, Blocks.AIR.defaultBlockState());
            }
        } else {
            BlockState st = s;
            while ((s = level.getBlockState((BlockPos)position.move(0, -1, 0))).isAir()) {
            }
            hasSnow = s.is(BlockTags.SNOW);
            if (hasSnow) {
                do {
                    this.setBlock((LevelWriter)level, (BlockPos)position, Blocks.AIR.defaultBlockState());
                } while (level.getBlockState((BlockPos)position.move(0, -1, 0)).is(BlockTags.SNOW));
            }
            if (this.hasSpace(st) || replace && !st.is(Blocks.BEDROCK)) {
                this.setBlock((LevelWriter)level, pos, hasSnow && state.hasProperty((Property)BlockStateProperties.SNOWY) ? (BlockState)state.setValue((Property)BlockStateProperties.SNOWY, (Comparable)Boolean.valueOf(true)) : state);
            } else {
                return;
            }
        }
        if (hasSnow) {
            position = pos.mutable();
            while (!level.getBlockState((BlockPos)position.move(0, 1, 0)).isAir()) {
            }
            SnowCoverage.snow(level, level.getRandom(), position);
        }
    }

    @Override
    protected void setBlockSensitive(WorldGenLevel level, RandomSource random, BlockPos pos, BlockState state, float chance) {
        if (random.nextFloat() <= chance) {
            BlockPos.MutableBlockPos position = pos.mutable();
            BlockState s = level.getBlockState(pos);
            boolean hasSnow = s.is(BlockTags.SNOW);
            if (hasSnow) {
                this.setBlock((LevelWriter)level, pos, state.hasProperty((Property)BlockStateProperties.SNOWY) ? (BlockState)state.setValue((Property)BlockStateProperties.SNOWY, (Comparable)Boolean.valueOf(true)) : state);
                while (level.getBlockState((BlockPos)position.move(0, 1, 0)).is(BlockTags.SNOW)) {
                    this.setBlock((LevelWriter)level, (BlockPos)position, Blocks.AIR.defaultBlockState());
                }
            } else {
                BlockState st = s;
                while ((s = level.getBlockState((BlockPos)position.move(0, -1, 0))).isAir()) {
                }
                hasSnow = s.is(BlockTags.SNOW);
                if (hasSnow) {
                    do {
                        this.setBlock((LevelWriter)level, (BlockPos)position, Blocks.AIR.defaultBlockState());
                    } while (level.getBlockState((BlockPos)position.move(0, -1, 0)).is(BlockTags.SNOW));
                }
                if (st.isAir()) {
                    this.setBlock((LevelWriter)level, pos, hasSnow && state.hasProperty((Property)BlockStateProperties.SNOWY) ? (BlockState)state.setValue((Property)BlockStateProperties.SNOWY, (Comparable)Boolean.valueOf(true)) : state);
                } else {
                    return;
                }
            }
            if (hasSnow) {
                position = pos.mutable();
                while (!level.getBlockState((BlockPos)position.move(0, 1, 0)).isAir()) {
                }
                SnowCoverage.snow(level, level.getRandom(), position);
            }
        }
    }

    protected void flatCanopy(WorldGenLevel level, RandomSource random, BlockPos pos, BlockState leaves, int size) {
        int posX = pos.getX();
        int posZ = pos.getZ();
        int y = pos.getY();
        for (int x = posX - size; x <= posX + size; ++x) {
            for (int z = posZ - size; z <= posZ + size; ++z) {
                pos = new BlockPos(x, y, z);
                this.setBlockSensitive(level, random, pos, leaves, (float)size - (float)Math.sqrt(Math.pow(posX - x, 2.0) + Math.pow(posZ - z, 2.0)));
                if (!level.getBlockState(pos).is(leaves.getBlock()) || !(random.nextFloat() <= 0.2f)) continue;
                this.setBlockSensitive(level, random, new BlockPos(x, y - 1, z), leaves, 1.0f);
                this.setBlockSensitive(level, random, new BlockPos(x, y - 2, z), leaves, 0.5f);
            }
        }
    }

    protected void branch(WorldGenLevel level, RandomSource random, BlockPos.MutableBlockPos pos, BlockState log, BlockState leaves, int directionX, int directionZ, int maxY) {
        int distance = 0;
        boolean hasLeaves = false;
        do {
            this.setBlock(level, (BlockPos)pos, log, true);
            if (distance > 2 && hasLeaves) {
                this.flatCanopy(level, random, (BlockPos)pos, leaves, 3);
            } else {
                hasLeaves = random.nextBoolean();
            }
            pos.move(random.nextInt(2) - directionX, random.nextInt(2), random.nextInt(2) - directionZ);
        } while (random.nextFloat() <= 0.7f && ++distance < 7 && pos.getY() < maxY);
        this.setBlock(level, (BlockPos)pos, log, true);
        this.flatCanopy(level, random, (BlockPos)pos, leaves, 3);
        this.flatCanopy(level, random, pos.above(), leaves, 2);
    }

    protected void root(WorldGenLevel level, RandomSource random, BlockPos.MutableBlockPos pos, BlockState log, int directionX, int directionZ) {
        BlockState state = level.getBlockState(pos.below());
        if (random.nextFloat() <= 0.3f && !state.isAir() && !state.is(Blocks.WATER)) {
            this.setBlock(level, pos.above(), log, false);
        }
        int distance = 0;
        do {
            if ((state = level.getBlockState((BlockPos)pos)).isAir() || state.is(Blocks.WATER)) {
                pos.move(0, -1, 0);
            }
            this.setBlock(level, (BlockPos)pos, log, true);
            pos.move(random.nextInt(2) - directionX, random.nextInt(2) - 1, random.nextInt(2) - directionZ);
        } while (++distance < 6 && random.nextFloat() <= 0.8f);
    }

    @Override
    public boolean place(TreeConfig config, WorldGenLevel level, ChunkGenerator chunkGen, RandomSource random, BlockPos pos) {
        if (this.canBeHere(level, random, pos, config)) {
            int treeType = random.nextInt(5) == 0 ? random.nextInt(3) : random.nextInt(2) + 1;
            int treeHeight = switch (treeType) {
                case 2 -> 13 + random.nextInt(4);
                case 1 -> 9 + random.nextInt(6);
                default -> 5 + random.nextInt(5);
            };
            int extraHeight = treeHeight + 1;
            if (this.heightCheck(level, pos, treeHeight, treeType + 1)) {
                BlockState log = config.log;
                BlockState leaves = config.leaves;
                switch (treeType) {
                    case 2: {
                        this.grow(level, pos.below(), log, extraHeight, true);
                        this.grow(level, pos.offset(-1, -1, -1), log, extraHeight, true);
                        this.grow(level, pos.offset(0, -1, -1), log, extraHeight, true);
                        this.grow(level, pos.offset(1, -1, -1), log, extraHeight, true);
                        this.grow(level, pos.offset(-1, -1, 0), log, extraHeight, true);
                        this.grow(level, pos.offset(1, -1, 0), log, extraHeight, true);
                        this.grow(level, pos.offset(-1, -1, 1), log, extraHeight, true);
                        this.grow(level, pos.offset(0, -1, 1), log, extraHeight, true);
                        this.grow(level, pos.offset(1, -1, 1), log, extraHeight, true);
                        if (random.nextFloat() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.getX() - 2, pos.getY(), pos.getZ() - 1), log, 1, random.nextInt(2));
                        }
                        if (random.nextFloat() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.getX() - 2, pos.getY(), pos.getZ()), log, 1, random.nextInt(2));
                        }
                        if (random.nextFloat() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.getX() - 2, pos.getY(), pos.getZ() + 1), log, 1, random.nextInt(2));
                        }
                        if (random.nextFloat() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.getX() + 2, pos.getY(), pos.getZ() - 1), log, 0, random.nextInt(2));
                        }
                        if (random.nextFloat() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.getX() + 2, pos.getY(), pos.getZ()), log, 0, random.nextInt(2));
                        }
                        if (random.nextFloat() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.getX() + 2, pos.getY(), pos.getZ() + 1), log, 0, random.nextInt(2));
                        }
                        if (random.nextFloat() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.getX() - 1, pos.getY(), pos.getZ() - 2), log, random.nextInt(2), 1);
                        }
                        if (random.nextFloat() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.getX(), pos.getY(), pos.getZ() - 2), log, random.nextInt(2), 1);
                        }
                        if (random.nextFloat() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.getX() + 1, pos.getY(), pos.getZ() - 2), log, random.nextInt(2), 1);
                        }
                        if (random.nextFloat() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.getX() - 1, pos.getY(), pos.getZ() + 2), log, random.nextInt(2), 0);
                        }
                        if (random.nextFloat() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.getX(), pos.getY(), pos.getZ() + 2), log, random.nextInt(2), 0);
                        }
                        if (random.nextFloat() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.getX() + 1, pos.getY(), pos.getZ() + 2), log, random.nextInt(2), 0);
                        }
                        treeType = treeHeight;
                        for (treeHeight = extraHeight - 6 - random.nextInt(5); treeHeight < extraHeight; ++treeHeight) {
                            if (random.nextFloat() <= 0.17f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.getX() - 2, pos.getY() + treeHeight, pos.getZ() - 1), log, leaves, 1, random.nextInt(2), treeType);
                            }
                            if (random.nextFloat() <= 0.17f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.getX() - 2, pos.getY() + treeHeight, pos.getZ()), log, leaves, 1, random.nextInt(2), treeType);
                            }
                            if (random.nextFloat() <= 0.17f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.getX() - 2, pos.getY() + treeHeight, pos.getZ() + 1), log, leaves, 1, random.nextInt(2), treeType);
                            }
                            if (random.nextFloat() <= 0.17f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.getX() + 2, pos.getY() + treeHeight, pos.getZ() - 1), log, leaves, 0, random.nextInt(2), treeType);
                            }
                            if (random.nextFloat() <= 0.17f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.getX() + 2, pos.getY() + treeHeight, pos.getZ()), log, leaves, 0, random.nextInt(2), treeType);
                            }
                            if (random.nextFloat() <= 0.17f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.getX() + 2, pos.getY() + treeHeight, pos.getZ() + 1), log, leaves, 0, random.nextInt(2), treeType);
                            }
                            if (random.nextFloat() <= 0.17f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.getX() - 1, pos.getY() + treeHeight, pos.getZ() - 2), log, leaves, random.nextInt(2), 1, treeType);
                            }
                            if (random.nextFloat() <= 0.17f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.getX(), pos.getY() + treeHeight, pos.getZ() - 2), log, leaves, random.nextInt(2), 1, treeType);
                            }
                            if (random.nextFloat() <= 0.17f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.getX() + 1, pos.getY() + treeHeight, pos.getZ() - 2), log, leaves, random.nextInt(2), 1, treeType);
                            }
                            if (random.nextFloat() <= 0.17f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.getX() - 1, pos.getY() + treeHeight, pos.getZ() + 2), log, leaves, random.nextInt(2), 0, treeType);
                            }
                            if (random.nextFloat() <= 0.17f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.getX(), pos.getY() + treeHeight, pos.getZ() + 2), log, leaves, random.nextInt(2), 0, treeType);
                            }
                            if (!(random.nextFloat() <= 0.17f)) continue;
                            this.branch(level, random, new BlockPos.MutableBlockPos(pos.getX() + 1, pos.getY() + treeHeight, pos.getZ() + 2), log, leaves, random.nextInt(2), 0, treeType);
                        }
                        BlockPos.MutableBlockPos origin = pos.mutable();
                        for (treeHeight = -1; treeHeight < 2; ++treeHeight) {
                            for (treeType = -1; treeType < 2; ++treeType) {
                                pos = origin.offset(treeHeight, extraHeight, treeType);
                                this.flatCanopy(level, random, pos, leaves, 3);
                                pos = pos.below();
                                this.flatCanopy(level, random, pos, leaves, 4);
                                pos = pos.below();
                                this.flatCanopy(level, random, pos, leaves, 5);
                                pos = pos.below();
                                this.flatCanopy(level, random, pos, leaves, 6);
                                pos = pos.below();
                                this.flatCanopy(level, random, pos, leaves, 7);
                                this.flatCanopy(level, random, pos.below(), leaves, 7);
                            }
                        }
                        break;
                    }
                    case 1: {
                        this.wideGrow(level, pos, log, treeHeight, 0, 0, true);
                        if (random.nextFloat() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.getX() - 1, pos.getY(), pos.getZ()), log, 1, random.nextInt(2));
                        }
                        if (random.nextFloat() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.getX() - 1, pos.getY(), pos.getZ() + 1), log, 1, random.nextInt(2));
                        }
                        if (random.nextFloat() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.getX(), pos.getY(), pos.getZ() - 1), log, random.nextInt(2), 1);
                        }
                        if (random.nextFloat() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.getX() + 1, pos.getY(), pos.getZ() - 1), log, random.nextInt(2), 1);
                        }
                        if (random.nextFloat() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.getX(), pos.getY(), pos.getZ() + 2), log, random.nextInt(2), 0);
                        }
                        if (random.nextFloat() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.getX() + 1, pos.getY(), pos.getZ() + 2), log, random.nextInt(2), 0);
                        }
                        if (random.nextFloat() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.getX() + 2, pos.getY(), pos.getZ()), log, 0, random.nextInt(2));
                        }
                        if (random.nextFloat() <= 0.2f) {
                            this.root(level, random, new BlockPos.MutableBlockPos(pos.getX() + 2, pos.getY(), pos.getZ() + 1), log, 0, random.nextInt(2));
                        }
                        for (treeType = extraHeight - 5 - random.nextInt(5); treeType < extraHeight; ++treeType) {
                            if (random.nextFloat() <= 0.25f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.getX() - 1, pos.getY() + treeType, pos.getZ()), log, leaves, 1, random.nextInt(2), treeHeight);
                            }
                            if (random.nextFloat() <= 0.25f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.getX() - 1, pos.getY() + treeType, pos.getZ() + 1), log, leaves, 1, random.nextInt(2), treeHeight);
                            }
                            if (random.nextFloat() <= 0.25f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.getX(), pos.getY() + treeType, pos.getZ() - 1), log, leaves, random.nextInt(2), 1, treeHeight);
                            }
                            if (random.nextFloat() <= 0.25f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.getX() + 1, pos.getY() + treeType, pos.getZ() - 1), log, leaves, random.nextInt(2), 1, treeHeight);
                            }
                            if (random.nextFloat() <= 0.25f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.getX(), pos.getY() + treeType, pos.getZ() + 2), log, leaves, random.nextInt(2), 0, treeHeight);
                            }
                            if (random.nextFloat() <= 0.25f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.getX() + 1, pos.getY() + treeType, pos.getZ() + 2), log, leaves, random.nextInt(2), 0, treeHeight);
                            }
                            if (random.nextFloat() <= 0.25f) {
                                this.branch(level, random, new BlockPos.MutableBlockPos(pos.getX() + 2, pos.getY() + treeType, pos.getZ()), log, leaves, 0, random.nextInt(2), treeHeight);
                            }
                            if (!(random.nextFloat() <= 0.25f)) continue;
                            this.branch(level, random, new BlockPos.MutableBlockPos(pos.getX() + 2, pos.getY() + treeType, pos.getZ() + 1), log, leaves, 0, random.nextInt(2), treeHeight);
                        }
                        pos = pos.offset(0, extraHeight, 0);
                        this.flatCanopy(level, random, pos, leaves, 3);
                        pos = pos.below();
                        this.flatCanopy(level, random, pos, leaves, 4);
                        pos = pos.below();
                        this.flatCanopy(level, random, pos, leaves, 5);
                        pos = pos.below();
                        this.flatCanopy(level, random, pos, leaves, 6);
                        this.flatCanopy(level, random, pos.below(), leaves, 6);
                        break;
                    }
                    default: {
                        this.grow(level, pos, log, treeHeight, true);
                        pos = pos.offset(0, extraHeight, 0);
                        this.flatCanopy(level, random, pos, leaves, 2);
                        pos = pos.below();
                        this.flatCanopy(level, random, pos, leaves, 3);
                        pos = pos.below();
                        this.flatCanopy(level, random, pos, leaves, 4);
                        pos = pos.below();
                        this.flatCanopy(level, random, pos, leaves, 5);
                        for (treeHeight = -1; treeHeight < 2; ++treeHeight) {
                            for (extraHeight = -1; extraHeight < 2; ++extraHeight) {
                                if (!(random.nextFloat() <= 0.4f)) continue;
                                BlockPos.MutableBlockPos m = new BlockPos.MutableBlockPos(pos.getX() + treeHeight, pos.getY(), pos.getZ() + extraHeight);
                                this.setBlock(level, (BlockPos)m, log, true);
                                this.flatCanopy(level, random, (BlockPos)m, leaves, 3);
                            }
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }
}

