/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.tree;

import divinerpg.registries.BlockRegistry;
import divinerpg.world.feature.config.tree.TreeConfig;
import divinerpg.world.feature.tree.DivineTree;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;

public class AuroraoakTree
extends DivineTree {
    protected void gradualGrowth(WorldGenLevel level, RandomSource random, BlockPos.MutableBlockPos pos, BlockState log, BlockState leaves, int maxY, float curvatureChance, float splitChance, boolean replace) {
        this.setBlock(level, (BlockPos)pos, log, replace);
        for (int y = 0; y <= maxY; ++y) {
            this.setBlock(level, (BlockPos)pos.move(random.nextFloat() < curvatureChance ? random.nextInt(3) - 1 : 0, 1, random.nextFloat() < curvatureChance ? random.nextInt(3) - 1 : 0), log, replace);
            if (!(random.nextFloat() < splitChance)) continue;
            this.gradualGrowth(level, random, new BlockPos.MutableBlockPos(pos.getX() + random.nextInt(3) - 1, pos.getY(), pos.getZ() + random.nextInt(3) - 1), log, leaves, maxY - y, curvatureChance + 0.08f, splitChance, replace);
        }
        this.growLeaves(level, random, (BlockPos)pos.move(0, 1, 0), leaves);
    }

    @Override
    protected boolean defaultGrowOn(BlockState state) {
        return state.is(BlockTags.SNOW) || state.is((Block)BlockRegistry.frozenGrass.get()) || state.is((Block)BlockRegistry.frozenDirt.get()) || state.is((Block)BlockRegistry.frozenStone.get()) || state.is(Blocks.PACKED_ICE) || state.is((Block)BlockRegistry.cobbledFrozenStone.get());
    }

    @Override
    public boolean hasSpace(BlockState state) {
        return state.is(BlockTags.SNOW) || super.hasSpace(state);
    }

    @Override
    public boolean place(TreeConfig config, WorldGenLevel level, ChunkGenerator chunkGen, RandomSource random, BlockPos pos) {
        if (this.canBeHere(level, random, pos, config)) {
            int treeType;
            int treeHeight;
            int extraHeight;
            if (level.getBlockState(pos.below()).is(BlockTags.SNOW)) {
                pos = pos.below();
            }
            if (this.heightCheck(level, pos, extraHeight = (treeHeight = (treeType = random.nextInt(4)) == 0 ? 3 + random.nextInt(3) : 4 + random.nextInt(7)) + 2, 1)) {
                BlockState log = config.log;
                BlockState leaves = config.leaves;
                if (treeType == 0) {
                    this.grow(level, pos, log, 1, 0, true);
                    this.grow(level, random, pos.above(), log, 1, 0, true, 0.25f);
                    this.grow(level, pos, log, treeHeight, true);
                    this.grow(level, pos.offset(0, treeHeight + 1, 0), leaves, extraHeight -= treeHeight);
                    this.grow(level, pos.offset(0, treeHeight - 1, 0), leaves, extraHeight + 2, 1, 0);
                    int branchY = treeHeight - random.nextInt(4);
                    int r = random.nextInt(3);
                    extraHeight = treeHeight - branchY;
                    this.grow(level, random, pos.offset(0, branchY - 1, 0), log, 1, 0, 0.2f);
                    this.growBranch(level, random, pos.offset(-1, branchY, -1), log, leaves, r > extraHeight ? 0 : extraHeight - r, extraHeight, extraHeight > 1, false);
                    branchY = treeHeight - random.nextInt(4);
                    r = random.nextInt(3);
                    extraHeight = treeHeight - branchY;
                    this.growBranch(level, random, pos.offset(1, branchY, 1), log, leaves, r > extraHeight ? 0 : extraHeight - r, extraHeight, extraHeight > 1, true);
                } else {
                    this.gradualGrowth(level, random, pos.mutable(), log, leaves, treeHeight, 0.2f, 0.1f, true);
                }
                return true;
            }
        }
        return false;
    }

    private void growBranch(WorldGenLevel level, RandomSource random, BlockPos pos, BlockState log, BlockState leaves, int height, int treeHeight, boolean shift, boolean direction) {
        if (height < 0) {
            return;
        }
        this.grow(level, pos, log, height, true);
        this.grow(level, pos.offset(0, height + 1, 0), leaves, treeHeight - height);
        this.grow(level, shift ? pos.offset(0, 1, 0) : pos, leaves, treeHeight - (shift ? 1 : 0), 1, 0);
        int r = random.nextInt(3);
        int s = random.nextInt(3) - 1;
        if (treeHeight > r) {
            this.growBranch(level, random, pos.offset(direction ? 1 : -1, r, direction ? 1 : -1), log, leaves, height - r + s, treeHeight - r + s, false, direction);
        }
    }

    protected void growLeaves(WorldGenLevel level, RandomSource random, BlockPos pos, BlockState leaves) {
        int type = random.nextInt(4);
        if (type == 3) {
            type = random.nextInt(4);
        }
        this.grow(level, pos, leaves, 1, 1);
        this.grow(level, pos, leaves, 2, 2);
        if (type > 0) {
            this.grow(level, pos, leaves, 2, 0);
            if (type > 1) {
                this.grow(level, pos, leaves, 3, 0);
                if (type == 3) {
                    this.grow(level, pos, leaves, 4, 1);
                    this.grow(level, pos, leaves, 4, -1);
                    this.grow(level, pos.offset(0, 2, 0), leaves, 2, 2);
                    this.grow(level, pos.offset(0, 3, 0), leaves, 3, 0);
                    this.setBlock(level, pos.offset(0, 4, 0), leaves, false);
                }
            }
        }
        this.grow(level, pos.offset(0, 2, 0), leaves, 2, 0);
        pos = pos.below();
        this.grow(level, pos, leaves, 2 + (type == 3 ? 2 : type));
        this.grow(level, pos, leaves, 2, 1, 0);
        this.grow(level, pos.below(), leaves, 2, 0);
        if (type == 3) {
            this.grow(level, pos, leaves, 2, 1, 1);
            this.grow(level, pos, leaves, 2, 2, 1);
            this.grow(level, pos, leaves, 2, 2, 0);
            this.grow(level, pos, leaves, 2, 2, -1);
            this.grow(level, pos.below(), leaves, 2, 2);
            this.grow(level, pos.offset(0, -2, 0), leaves, 3, 0);
        }
    }
}

