/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.tree;

import divinerpg.registries.BlockRegistry;
import divinerpg.world.feature.config.tree.TreeConfig;
import divinerpg.world.feature.tree.DivineTree;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class ApalachiaTree
extends DivineTree {
    public static NormalNoise vegetation;
    public static long seed;

    @Override
    protected boolean defaultGrowOn(BlockState state) {
        return state.is((Block)BlockRegistry.apalachiaDirt.get()) || state.is((Block)BlockRegistry.apalachiaGrass.get());
    }

    @Override
    public boolean place(TreeConfig config, WorldGenLevel level, ChunkGenerator chunkGen, RandomSource random, BlockPos pos) {
        if (this.canBeHere(level, random, pos, config)) {
            int extraHeight;
            long newSeed = level.getSeed();
            if (seed != newSeed) {
                vegetation = NormalNoise.create((RandomSource)new XoroshiroRandomSource(newSeed), (int)-2, (double[])new double[]{1.25});
                seed = newSeed;
            }
            int treeHeight = random.nextInt(10) + (int)(vegetation.getValue((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) * 8.0);
            int treeType = random.nextInt(13);
            if (treeHeight < 0) {
                treeHeight = 1;
            }
            switch (treeType) {
                case 0: 
                case 1: {
                    extraHeight = treeHeight + 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    extraHeight = treeHeight + 2;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    extraHeight = treeHeight + 1;
                    break;
                }
                default: {
                    if (random.nextBoolean()) {
                        return super.place(config, level, chunkGen, random, pos);
                    }
                    treeHeight = 3 + random.nextInt(3);
                    extraHeight = treeHeight + 4;
                }
            }
            if (this.heightCheck(level, pos, extraHeight, 1)) {
                BlockState log = config.log;
                BlockState leaves = config.leaves;
                if (treeType != 12) {
                    this.grow(level, pos, log, treeHeight);
                }
                switch (treeType) {
                    case 0: {
                        this.grow(level, random, pos.offset(0, treeHeight - 1, 0), leaves, 2, 0, 0.5f);
                    }
                    case 1: {
                        this.grow(level, pos.offset(0, treeHeight - 2, 0), leaves, 3, 1, 0);
                        this.grow(level, pos.offset(0, treeHeight - 1, 0), leaves, 1, 1, 1);
                        this.grow(level, pos.offset(0, treeHeight + 1, 0), leaves, extraHeight - 1 - treeHeight);
                        break;
                    }
                    case 2: {
                        this.grow(level, random, pos.offset(0, treeHeight - 1, 0), leaves, 1, 1, 0.5f);
                    }
                    case 3: {
                        this.grow(level, pos.offset(0, treeHeight - 1, 0), leaves, 1, 1, 0);
                        this.grow(level, pos.offset(0, treeHeight + 1, 0), leaves, extraHeight - 1 - treeHeight);
                        break;
                    }
                    case 4: 
                    case 5: {
                        this.grow(level, pos.offset(0, treeHeight + 1, 0), leaves, extraHeight - 1 - treeHeight);
                        this.grow(level, pos.offset(0, treeHeight - 2, 0), leaves, extraHeight + 2 - treeHeight, 1, 0);
                        this.grow(level, pos.offset(0, treeHeight - 1, 0), leaves, 2, 1, 1);
                        this.grow(level, pos.offset(0, treeHeight - 1, 0), leaves, 2, 2, 0);
                        this.grow(level, pos.offset(0, treeHeight, 0), leaves, 2, 1);
                        this.grow(level, pos.offset(0, treeHeight, 0), leaves, 2, -1);
                        break;
                    }
                    case 6: 
                    case 7: {
                        this.setBlock((LevelWriter)level, pos.offset(0, extraHeight, 0), leaves);
                        this.grow(level, pos.offset(0, treeHeight, 0), leaves, 1, 0);
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        this.setBlock((LevelWriter)level, pos.offset(0, extraHeight, 0), leaves);
                        this.grow(level, pos.offset(0, treeHeight - 1, 0), leaves, extraHeight + 1 - treeHeight, 1, 0);
                        this.grow(level, pos.offset(0, treeHeight, 0), leaves, 1, 1);
                        if (treeType == 8 || treeType == 9) break;
                        for (int offset = -1; offset < 2; ++offset) {
                            this.grow(level, pos.offset(0, treeHeight, 0), leaves, 2, offset);
                        }
                        break;
                    }
                    default: {
                        BlockPos temp = pos.offset(0, -2, 0);
                        this.grow(level, temp, log, 1, true);
                        this.grow(level, temp, log, 1, 1, 0, true);
                        temp = temp.above();
                        this.grow(level, temp, log, 1, 1, true);
                        this.grow(level, temp, log, 1, 2, 0, true);
                        this.grow(level, temp, log, 2, 2, -1, true);
                        this.grow(level, temp, log, 2, 2, 1, true);
                        this.grow(level, temp, log, 2, 2, true);
                        this.grow(level, temp, log, 3, 0, true);
                        temp = pos.above();
                        this.grow(level, temp, leaves, 2, 0);
                        this.grow(level, temp.above(), log, 2, 0);
                        this.grow(level, temp, log, 2, 1, 1);
                        this.grow(level, temp.above(), log, treeHeight - 2, 1, 0);
                        this.grow(level, pos.offset(0, treeHeight, 0), leaves, 1, 1, 1);
                        this.grow(level, pos.offset(0, extraHeight - 1, 0), log, 1, 1);
                        this.setBlock((LevelWriter)level, pos.offset(0, extraHeight, 0), leaves);
                        this.grow(level, pos.offset(0, extraHeight, 0), leaves, 1, 0);
                        this.grow(level, pos.offset(0, extraHeight, 0), leaves, 1, 1);
                        for (int offset = -1; offset < 2; ++offset) {
                            this.grow(level, pos.offset(0, treeHeight + 1, 0), leaves, extraHeight - 2 - treeHeight, 2, offset);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }
}

