/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.pond;

import divinerpg.registries.BlockRegistry;
import divinerpg.world.ConfiguredFeatureKeys;
import divinerpg.world.feature.config.RuleTestConfig;
import divinerpg.world.placement.Surface;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class GeothermalPond
extends Feature<RuleTestConfig> {
    public GeothermalPond() {
        super(RuleTestConfig.CODEC);
    }

    public boolean place(FeaturePlaceContext<RuleTestConfig> context) {
        return this.place((RuleTestConfig)context.config(), context.level(), (ChunkGenerator)null, context.random(), context.origin());
    }

    public boolean place(RuleTestConfig config, WorldGenLevel level, ChunkGenerator g, RandomSource random, BlockPos pos) {
        if (this.canSustain(config.rules, level, random, pos)) {
            ArrayList<BlockPos> list = new ArrayList<BlockPos>();
            this.generate(list, config.rules, level, random, pos);
            if (list.isEmpty()) {
                return false;
            }
            for (BlockPos p : list) {
                this.decorate(list, config.rules, level, random, p);
            }
            return true;
        }
        return false;
    }

    public final boolean rule(List<RuleTest> rules, RandomSource random, BlockState state) {
        if (rules.isEmpty() && this.standardRule(state)) {
            return true;
        }
        for (RuleTest test : rules) {
            if (!test.test(state, random)) continue;
            return true;
        }
        return false;
    }

    public boolean standardRule(BlockState state) {
        return state.is(BlockTags.MOSS_REPLACEABLE) || state.is(BlockTags.SNOW) || state.is(BlockTags.ICE);
    }

    protected boolean canSustain(List<RuleTest> rules, WorldGenLevel level, RandomSource random, BlockPos pos) {
        return Surface.hasSpace(level, pos.above()) && !Surface.hasSpace(level, pos.below()) && this.rule(rules, random, level.getBlockState(pos));
    }

    protected void generate(ArrayList<BlockPos> positions, List<RuleTest> rules, WorldGenLevel level, RandomSource random, BlockPos pos) {
        if ((positions.isEmpty() || Math.sqrt(Math.pow(pos.getX() - positions.get(0).getX(), 2.0) + Math.pow(pos.getZ() - positions.get(0).getZ(), 2.0)) < 8.0) && (double)random.nextFloat() < 0.8) {
            this.setBlock((LevelWriter)level, pos, Blocks.WATER.defaultBlockState());
            positions.add(pos);
            BlockPos north = pos.north();
            BlockPos south = pos.south();
            BlockPos east = pos.east();
            BlockPos west = pos.west();
            if (!positions.contains(north) && this.canSustain(rules, level, random, north)) {
                this.generate(positions, rules, level, random, north);
            }
            if (!positions.contains(east) && this.canSustain(rules, level, random, east)) {
                this.generate(positions, rules, level, random, east);
            }
            if (!positions.contains(south) && this.canSustain(rules, level, random, south)) {
                this.generate(positions, rules, level, random, south);
            }
            if (!positions.contains(west) && this.canSustain(rules, level, random, west)) {
                this.generate(positions, rules, level, random, west);
            }
        }
    }

    protected void decorate(ArrayList<BlockPos> positions, List<RuleTest> rules, WorldGenLevel level, RandomSource random, BlockPos pos) {
        BlockPos north = pos.north();
        BlockPos south = pos.south();
        BlockPos east = pos.east();
        BlockPos west = pos.west();
        if (positions.contains(north) && positions.contains(east) && positions.contains(south) && positions.contains(west)) {
            this.genDeep(rules, level, random, pos);
        } else {
            this.genShallow(rules, level, random, pos);
            this.tryGenEdge(rules, level, random, north);
            this.tryGenEdge(rules, level, random, east);
            this.tryGenEdge(rules, level, random, south);
            this.tryGenEdge(rules, level, random, west);
        }
    }

    protected void tryGenEdge(List<RuleTest> rules, WorldGenLevel level, RandomSource random, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (!state.getOptionalValue((Property)BlockStateProperties.WATERLOGGED).orElseGet(() -> state.is(Blocks.WATER)).booleanValue()) {
            this.genEdge(rules, level, random, pos);
        }
    }

    protected void genDeep(List<RuleTest> rules, WorldGenLevel level, RandomSource random, BlockPos pos) {
        pos = pos.below();
        this.setBlock((LevelWriter)level, pos, Blocks.WATER.defaultBlockState());
        if ((double)random.nextFloat() < 0.1) {
            ((ConfiguredFeature)ConfiguredFeatureKeys.getConfiguredFeature(level, ConfiguredFeatureKeys.THERMAL_VENT).value()).place(level, null, random, pos);
        }
        if (this.rule(rules, random, level.getBlockState(pos.below()))) {
            if (random.nextFloat() < 0.4f) {
                this.setBlock((LevelWriter)level, pos.below(), Blocks.GRAVEL.defaultBlockState());
            } else if (random.nextFloat() < 0.3f) {
                this.setBlock((LevelWriter)level, pos.below(), Blocks.CLAY.defaultBlockState());
            } else if (random.nextFloat() < 0.2f) {
                pos = pos.below();
                this.setBlock((LevelWriter)level, pos, Blocks.MAGMA_BLOCK.defaultBlockState());
                pos = pos.below();
                if (Surface.hasSpace(level, pos) || this.rule(rules, random, level.getBlockState(pos))) {
                    this.setBlock((LevelWriter)level, pos, ((Block)BlockRegistry.coalstone.get()).defaultBlockState());
                }
            } else if (random.nextFloat() < 0.2f) {
                this.setBlock((LevelWriter)level, pos.below(), ((Block)BlockRegistry.coalstone.get()).defaultBlockState());
            } else if (random.nextFloat() < 0.05f) {
                this.setBlock((LevelWriter)level, pos.below(), Blocks.OBSIDIAN.defaultBlockState());
            } else {
                this.setBlock((LevelWriter)level, pos.below(), ((Block)BlockRegistry.frozenGravel.get()).defaultBlockState());
            }
        }
    }

    protected void genShallow(List<RuleTest> rules, WorldGenLevel level, RandomSource random, BlockPos pos) {
        pos = pos.below();
        if (random.nextFloat() < 0.3f) {
            this.setBlock((LevelWriter)level, pos, Blocks.CLAY.defaultBlockState());
        } else if (random.nextFloat() < 0.4f) {
            this.setBlock((LevelWriter)level, pos, Blocks.GRAVEL.defaultBlockState());
        } else {
            this.setBlock((LevelWriter)level, pos, ((Block)BlockRegistry.frozenGravel.get()).defaultBlockState());
        }
    }

    protected void genEdge(List<RuleTest> rules, WorldGenLevel level, RandomSource random, BlockPos pos) {
        if (random.nextFloat() < 0.4f) {
            this.setBlock((LevelWriter)level, pos, Blocks.CLAY.defaultBlockState());
        } else if (random.nextFloat() < 0.3f) {
            this.setBlock((LevelWriter)level, pos, Blocks.GRAVEL.defaultBlockState());
        } else if (random.nextFloat() < 0.1f) {
            this.setBlock((LevelWriter)level, pos, ((Block)BlockRegistry.frozenGravel.get()).defaultBlockState());
        } else {
            this.setBlock((LevelWriter)level, pos, ((Block)BlockRegistry.cobbledFrozenStone.get()).defaultBlockState());
        }
    }
}

