/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.plant;

import divinerpg.registries.BlockRegistry;
import divinerpg.world.ConfiguredFeatureKeys;
import divinerpg.world.placement.Underground;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class BrittleCavesVegetation
extends Feature<NoneFeatureConfiguration> {
    public BrittleCavesVegetation() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        return this.place((NoneFeatureConfiguration)null, context.level(), (ChunkGenerator)null, context.random(), context.origin());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean place(NoneFeatureConfiguration c, WorldGenLevel level, ChunkGenerator g, RandomSource random, BlockPos pos) {
        BlockState state;
        if (!level.ensureCanWrite(pos) || !Underground.isUnderground((LevelAccessor)level, pos) || pos.getY() >= 63) return false;
        BlockPos.MutableBlockPos mut = pos.mutable();
        if (this.isAirOrVine(level.getBlockState(pos))) {
            for (int i = 0; this.isAirOrVine(level.getBlockState((BlockPos)mut.move(Direction.UP))) && i < 16; ++i) {
            }
        }
        if (!(state = level.getBlockState((BlockPos)mut)).is(Blocks.MOSS_BLOCK) && !state.is(BlockTags.MOSS_REPLACEABLE) && !state.is(BlockTags.SNOW)) return false;
        if (state.is(Blocks.MOSS_BLOCK)) {
            if (!level.getBlockState((BlockPos)mut.move(Direction.UP)).isAir()) return false;
            if (random.nextBoolean()) {
                this.setBlock((LevelWriter)level, (BlockPos)mut, Blocks.MOSS_CARPET.defaultBlockState());
            } else if (random.nextBoolean()) {
                this.setBlock((LevelWriter)level, (BlockPos)mut, Blocks.SHORT_GRASS.defaultBlockState());
            } else if (random.nextBoolean()) {
                this.setBlock((LevelWriter)level, (BlockPos)mut, Blocks.AZALEA.defaultBlockState());
            } else if (random.nextBoolean()) {
                this.setBlock((LevelWriter)level, (BlockPos)mut, Blocks.FLOWERING_AZALEA.defaultBlockState());
            } else {
                this.setBlock((LevelWriter)level, (BlockPos)mut, Blocks.BLUE_ORCHID.defaultBlockState());
            }
        } else {
            if (!level.getBlockState(mut.above()).isAir() && !level.getBlockState(mut.below()).isAir()) return false;
            this.setBlock((LevelWriter)level, (BlockPos)mut, ((Block)BlockRegistry.brittleMoss.get()).defaultBlockState());
            if (random.nextBoolean()) {
                ((ConfiguredFeature)ConfiguredFeatureKeys.getConfiguredFeature(level, ConfiguredFeatureKeys.BRITTLE_PLANTS).value()).place(level, g, random, (BlockPos)mut);
            }
        }
        if (random.nextBoolean()) {
            this.place((NoneFeatureConfiguration)null, level, (ChunkGenerator)null, random, mut.offset(random.nextInt(5) - 2, random.nextInt(3) - 1, random.nextInt(5) - 2));
        }
        if (!random.nextBoolean()) return true;
        this.place((NoneFeatureConfiguration)null, level, (ChunkGenerator)null, random, mut.offset(random.nextInt(5) - 2, random.nextInt(3) - 1, random.nextInt(5) - 2));
        return true;
    }

    public boolean isAirOrVine(BlockState state) {
        return state.isAir() || state.is(BlockRegistry.winterberryVinesHead) || state.is(BlockRegistry.winterberryVinesBody);
    }
}

