/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.ore;

import divinerpg.world.feature.config.ore.OreVeinConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class OreVein
extends Feature<OreVeinConfig> {
    public OreVein() {
        super(OreVeinConfig.CODEC);
    }

    public boolean place(OreVeinConfig config, WorldGenLevel level, ChunkGenerator generator, RandomSource random, BlockPos origin) {
        List<OreVeinConfig.TargetBlockState> states = config.targetStates;
        if (VeinArm.canBeHere(level, origin, states, random)) {
            new VeinArm(origin, Direction.getRandom((RandomSource)random)).run(level, random, origin, config.cutoffChance, config.straightness, config.branchingChance, states);
            return true;
        }
        return false;
    }

    public boolean place(FeaturePlaceContext<OreVeinConfig> context) {
        return this.place((OreVeinConfig)context.config(), context.level(), context.chunkGenerator(), context.random(), context.origin());
    }

    public static class VeinArm {
        Direction direction;
        BlockPos pos;

        public VeinArm(BlockPos p, Direction dir) {
            this.pos = p;
            this.direction = dir;
        }

        public static boolean canBeHere(WorldGenLevel level, BlockPos pos, List<OreVeinConfig.TargetBlockState> states, RandomSource random) {
            BlockState state = level.getBlockState(pos);
            for (OreVeinConfig.TargetBlockState targetState : states) {
                if (targetState.state.is(state.getBlock())) {
                    return true;
                }
                if (!targetState.target.test(state, random)) continue;
                return true;
            }
            return false;
        }

        public void run(WorldGenLevel level, RandomSource random, BlockPos origin, float cutoffChance, float straightness, float branchingChance, List<OreVeinConfig.TargetBlockState> states) {
            while (level.getChunk(origin) == level.getChunk(this.pos) && VeinArm.canBeHere(level, this.pos, states, random) && random.nextFloat() > cutoffChance) {
                this.setVeinPart(level, random, this.pos, states);
                this.setVeinPart(level, random, this.pos.above(), states);
                this.setVeinPart(level, random, this.pos.below(), states);
                this.setVeinPart(level, random, this.pos.north(), states);
                this.setVeinPart(level, random, this.pos.east(), states);
                this.setVeinPart(level, random, this.pos.west(), states);
                this.setVeinPart(level, random, this.pos.south(), states);
                this.pos = this.pos.relative(this.direction);
                if (random.nextFloat() > straightness) {
                    this.direction = Direction.getRandom((RandomSource)random);
                }
                if (!(random.nextFloat() <= branchingChance)) continue;
                new VeinArm(this.pos, Direction.getRandom((RandomSource)random)).run(level, random, origin, cutoffChance, straightness, branchingChance, states);
            }
        }

        public void setVeinPart(WorldGenLevel level, RandomSource random, BlockPos pos, List<OreVeinConfig.TargetBlockState> states) {
            if (random.nextBoolean()) {
                pos = pos.relative(Direction.getRandom((RandomSource)random));
            }
            OreVeinConfig.TargetBlockState targetState = states.get(random.nextInt(states.size()));
            if (random.nextFloat() <= targetState.chance && targetState.target.test(level.getBlockState(pos), random) && (random.nextFloat() > targetState.discardChanceOnAirExposure || !this.checkForAir(level, pos))) {
                level.setBlock(pos, targetState.state, 3);
            }
        }

        public boolean checkForAir(WorldGenLevel level, BlockPos pos) {
            return level.isEmptyBlock(pos.above()) || level.isEmptyBlock(pos.below()) || level.isEmptyBlock(pos.north()) || level.isEmptyBlock(pos.south()) || level.isEmptyBlock(pos.east()) || level.isEmptyBlock(pos.west());
        }
    }
}

