/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.decoration;

import divinerpg.DivineRPG;
import divinerpg.world.placement.Surface;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SnowCoverage
extends Feature<NoneFeatureConfiguration> {
    public SnowCoverage() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        return this.place((NoneFeatureConfiguration)null, context.level(), context.chunkGenerator(), context.random(), context.origin());
    }

    public boolean place(NoneFeatureConfiguration c, WorldGenLevel level, ChunkGenerator g, RandomSource random, BlockPos pos) {
        int x;
        int i = 0;
        int maxX = x + 16;
        for (x = pos.getX() & 0xFFFFFFF0; x < maxX; ++x) {
            int z;
            int maxZ = z + 16;
            for (z = pos.getZ() & 0xFFFFFFF0; z < maxZ; ++z) {
                i = (byte)(i + SnowCoverage.snow(level, random, new BlockPos.MutableBlockPos(x, Surface.getSurface(Surface.Surface_Type.HIGHEST_GROUND, Surface.Mode.FULL, level.getMinBuildHeight(), level.getMaxBuildHeight(), 0, level, random, x, z), z)));
            }
        }
        return i > 0;
    }

    public static boolean isWaterBlock(BlockState state) {
        return state.is(Blocks.WATER) || state.is(Blocks.BUBBLE_COLUMN) || state.getOptionalValue((Property)BlockStateProperties.WATERLOGGED).orElse(false) != false || state.is(BlockTags.UNDERWATER_BONEMEALS) || state.is(Blocks.KELP) || state.is(Blocks.TALL_SEAGRASS);
    }

    public static byte snow(WorldGenLevel level, RandomSource random, BlockPos.MutableBlockPos position) {
        ChunkSource chunkSource = level.getChunkSource();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache source = (ServerChunkCache)chunkSource;
            while (SnowCoverage.isWaterBlock(level.getBlockState((BlockPos)position))) {
                position.move(0, 1, 0);
            }
            DensityFunction.SinglePointContext context = new DensityFunction.SinglePointContext(position.getX(), position.getY(), position.getZ());
            NoiseRouter router = source.randomState().router();
            double depth = (double)(((Biome)level.getBiome((BlockPos)position).value()).getModifiedClimateSettings().downfall() + ((Biome)level.getBiome(position.north()).value()).getModifiedClimateSettings().downfall() + ((Biome)level.getBiome(position.south()).value()).getModifiedClimateSettings().downfall() + ((Biome)level.getBiome(position.east()).value()).getModifiedClimateSettings().downfall() + ((Biome)level.getBiome(position.west()).value()).getModifiedClimateSettings().downfall()) / 5.0 * (router.vegetation().compute((DensityFunction.FunctionContext)context) + 1.1) + router.temperature().compute((DensityFunction.FunctionContext)context) + 1.0;
            if (depth >= 0.125) {
                BlockPos below = position.below();
                BlockState state = level.getBlockState(below);
                if (SnowCoverage.isWaterBlock(state)) {
                    level.setBlock(below, Blocks.ICE.defaultBlockState(), 3);
                } else {
                    if (state.is(Blocks.SNOW_BLOCK) || state.is(Blocks.SNOW) || state.is(Blocks.POWDER_SNOW) || state.is(BlockTags.ICE) || !state.isCollisionShapeFullBlock((BlockGetter)level, below)) {
                        return 0;
                    }
                    if (state.is(BlockTags.LEAVES)) {
                        depth -= 0.2;
                    }
                    if (state.hasProperty((Property)BlockStateProperties.SNOWY)) {
                        BlockPos.MutableBlockPos p = below.mutable();
                        SnowCoverage.snowLog(level, p, (BlockState)state.setValue((Property)BlockStateProperties.SNOWY, (Comparable)Boolean.valueOf(true)), new boolean[]{level.getBlockState(p.north()).isAir(), level.getBlockState(p.south()).isAir(), level.getBlockState(p.east()).isAir(), level.getBlockState(p.west()).isAir()});
                    }
                    if (depth >= 1.0) {
                        if (depth >= 2.0) {
                            depth = Math.floor(depth);
                            state = random.nextFloat() < 0.94f ? Blocks.POWDER_SNOW.defaultBlockState() : Blocks.SNOW_BLOCK.defaultBlockState();
                        } else {
                            state = Blocks.SNOW_BLOCK.defaultBlockState();
                        }
                        int k = (int)depth;
                        for (int i = 0; i < k; ++i) {
                            if (!level.getBlockState((BlockPos)position).isAir()) continue;
                            level.setBlock((BlockPos)position, state, 3);
                            position.move(0, 1, 0);
                        }
                        depth -= (double)k;
                    }
                    if (depth >= 0.125 && !state.is(Blocks.POWDER_SNOW) && level.getBlockState((BlockPos)position).isAir()) {
                        level.setBlock((BlockPos)position, (BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)BlockStateProperties.LAYERS, (Comparable)Integer.valueOf((int)(depth * 8.0))), 3);
                    }
                }
                return 1;
            }
        } else {
            DivineRPG.LOGGER.info("could not access server chunk cache");
        }
        return 0;
    }

    static void snowLog(WorldGenLevel level, BlockPos.MutableBlockPos pos, BlockState snowyBlock, boolean[] space) {
        BlockState nextState;
        level.setBlock((BlockPos)pos, snowyBlock, 2);
        pos.move(0, -1, 0);
        if (space[0] && !level.getBlockState(pos.north()).isAir()) {
            space[0] = false;
        }
        if (space[1] && !level.getBlockState(pos.south()).isAir()) {
            space[1] = false;
        }
        if (space[2] && !level.getBlockState(pos.east()).isAir()) {
            space[2] = false;
        }
        if (space[3] && !level.getBlockState(pos.west()).isAir()) {
            space[3] = false;
        }
        if ((space[0] || space[1] || space[2] || space[3]) && (nextState = level.getBlockState((BlockPos)pos)).is(snowyBlock.getBlock())) {
            SnowCoverage.snowLog(level, pos, (BlockState)nextState.setValue((Property)BlockStateProperties.SNOWY, (Comparable)Boolean.valueOf(true)), space);
        }
    }
}

