/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.decoration;

import divinerpg.blocks.iceika.BlockIcicle;
import divinerpg.registries.BlockRegistry;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.PointedDripstoneConfiguration;

public class Icicle
extends Feature<PointedDripstoneConfiguration> {
    public Icicle() {
        super(PointedDripstoneConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<PointedDripstoneConfiguration> p_191078_) {
        WorldGenLevel levelaccessor = p_191078_.level();
        BlockPos blockpos = p_191078_.origin();
        RandomSource randomsource = p_191078_.random();
        PointedDripstoneConfiguration pointeddripstoneconfiguration = (PointedDripstoneConfiguration)p_191078_.config();
        Optional<Direction> optional = Icicle.getTipDirection((LevelAccessor)levelaccessor, blockpos, randomsource);
        if (optional.isEmpty()) {
            return false;
        }
        BlockPos blockpos1 = blockpos.relative(optional.get().getOpposite());
        Icicle.createPatchOfPackedIce((LevelAccessor)levelaccessor, randomsource, blockpos1, pointeddripstoneconfiguration);
        int i = randomsource.nextFloat() < pointeddripstoneconfiguration.chanceOfTallerDripstone && DripstoneUtils.isEmptyOrWater((BlockState)levelaccessor.getBlockState(blockpos.relative(optional.get()))) ? 2 : 1;
        Icicle.growIcicle((LevelAccessor)levelaccessor, blockpos, optional.get(), i, false);
        return true;
    }

    private static Optional<Direction> getTipDirection(LevelAccessor p_225199_, BlockPos p_225200_, RandomSource p_225201_) {
        boolean flag = Icicle.isIcicleBase(p_225199_.getBlockState(p_225200_.above()));
        boolean flag1 = Icicle.isIcicleBase(p_225199_.getBlockState(p_225200_.below()));
        if (flag && flag1) {
            return Optional.of(p_225201_.nextBoolean() ? Direction.DOWN : Direction.UP);
        }
        if (flag) {
            return Optional.of(Direction.DOWN);
        }
        return flag1 ? Optional.of(Direction.UP) : Optional.empty();
    }

    private static void createPatchOfPackedIce(LevelAccessor p_225194_, RandomSource p_225195_, BlockPos p_225196_, PointedDripstoneConfiguration p_225197_) {
        Icicle.placePackedIceIfPossible(p_225194_, p_225196_);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (p_225195_.nextFloat() > p_225197_.chanceOfDirectionalSpread) continue;
            BlockPos blockpos = p_225196_.relative(direction);
            Icicle.placePackedIceIfPossible(p_225194_, blockpos);
            if (p_225195_.nextFloat() > p_225197_.chanceOfSpreadRadius2) continue;
            BlockPos blockpos1 = blockpos.relative(Direction.getRandom((RandomSource)p_225195_));
            Icicle.placePackedIceIfPossible(p_225194_, blockpos1);
            if (p_225195_.nextFloat() > p_225197_.chanceOfSpreadRadius3) continue;
            BlockPos blockpos2 = blockpos1.relative(Direction.getRandom((RandomSource)p_225195_));
            Icicle.placePackedIceIfPossible(p_225194_, blockpos2);
        }
    }

    protected static boolean placePackedIceIfPossible(LevelAccessor p_190854_, BlockPos p_190855_) {
        BlockState blockstate = p_190854_.getBlockState(p_190855_);
        if (Icicle.isIcicleBase(blockstate)) {
            if (!(blockstate.is((Block)BlockRegistry.brittleLeaves.get()) || blockstate.is(Blocks.ICE) || blockstate.is((Block)BlockRegistry.shiverspineLog.get()))) {
                p_190854_.setBlock(p_190855_, Blocks.PACKED_ICE.defaultBlockState(), 2);
            }
            return true;
        }
        return false;
    }

    protected static void growIcicle(LevelAccessor p_190848_, BlockPos p_190849_, Direction p_190850_, int p_190851_, boolean p_190852_) {
        if (Icicle.isIcicleBase(p_190848_.getBlockState(p_190849_.relative(p_190850_.getOpposite())))) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = p_190849_.mutable();
            Icicle.buildBaseToTipColumn(p_190850_, p_190851_, p_190852_, p_190846_ -> {
                if (p_190846_.is((Block)BlockRegistry.icicle.get())) {
                    p_190846_ = (BlockState)p_190846_.setValue((Property)BlockIcicle.WATERLOGGED, (Comparable)Boolean.valueOf(p_190848_.isWaterAt((BlockPos)blockpos$mutableblockpos)));
                }
                p_190848_.setBlock((BlockPos)blockpos$mutableblockpos, p_190846_, 2);
                blockpos$mutableblockpos.move(p_190850_);
            });
        }
    }

    public static boolean isIcicleBase(BlockState blockstate) {
        return blockstate.is(BlockTags.DRIPSTONE_REPLACEABLE) || blockstate.is(BlockTags.ICE) || blockstate.is((Block)BlockRegistry.brittleLeaves.get()) || blockstate.is((Block)BlockRegistry.shiverspineLog.get()) || blockstate.is(Blocks.GRAVEL);
    }

    protected static void buildBaseToTipColumn(Direction p_159652_, int p_159653_, boolean p_159654_, Consumer<BlockState> p_159655_) {
        if (p_159653_ >= 3) {
            p_159655_.accept(Icicle.createIcicle(p_159652_, DripstoneThickness.BASE));
            for (int i = 0; i < p_159653_ - 3; ++i) {
                p_159655_.accept(Icicle.createIcicle(p_159652_, DripstoneThickness.MIDDLE));
            }
        }
        if (p_159653_ >= 2) {
            p_159655_.accept(Icicle.createIcicle(p_159652_, DripstoneThickness.FRUSTUM));
        }
        if (p_159653_ >= 1) {
            p_159655_.accept(Icicle.createIcicle(p_159652_, p_159654_ ? DripstoneThickness.TIP_MERGE : DripstoneThickness.TIP));
        }
    }

    private static BlockState createIcicle(Direction p_159657_, DripstoneThickness p_159658_) {
        return (BlockState)((BlockState)((Block)BlockRegistry.icicle.get()).defaultBlockState().setValue((Property)BlockIcicle.TIP_DIRECTION, (Comparable)p_159657_)).setValue(BlockIcicle.THICKNESS, (Comparable)p_159658_);
    }
}

