/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.util;

import com.google.gson.Gson;
import com.mojang.authlib.GameProfile;
import divinerpg.entities.base.EntityDivineNeutral;
import divinerpg.registries.FluidRegistry;
import divinerpg.registries.LevelRegistry;
import divinerpg.world.placement.Surface;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.io.IOUtils;

public class Utils {
    public static volatile byte ICEIKA_WEATHER = (byte)(Math.random() * 4.0);
    private static final Set<UUID> DEV_LIST = ConcurrentHashMap.newKeySet();
    private static final Set<UUID> TESTER_LIST = ConcurrentHashMap.newKeySet();
    private static final Set<UUID> SPECIAL_LIST = ConcurrentHashMap.newKeySet();
    private static final Set<UUID> ARTIST_LIST = ConcurrentHashMap.newKeySet();
    private static final Set<UUID> FRIEND_LIST = ConcurrentHashMap.newKeySet();
    public static final Container EMPTY_CONTAINER = new Container(){

        public void clearContent() {
        }

        public int getContainerSize() {
            return 1;
        }

        public boolean isEmpty() {
            return true;
        }

        public ItemStack getItem(int i) {
            return ItemStack.EMPTY;
        }

        public ItemStack removeItem(int i, int i1) {
            return ItemStack.EMPTY;
        }

        public ItemStack removeItemNoUpdate(int i) {
            return ItemStack.EMPTY;
        }

        public void setItem(int i, ItemStack itemStack) {
        }

        public void setChanged() {
        }

        public boolean stillValid(Player player) {
            return true;
        }
    };
    public static final GameProfile FAKE_PLAYER = new GameProfile(UUID.randomUUID(), "drpgfakeplayer");

    public static boolean isDeveloperName(UUID name) {
        return DEV_LIST.contains(name);
    }

    public static boolean isTesterName(UUID name) {
        return TESTER_LIST.contains(name);
    }

    public static boolean isSpecial(UUID name) {
        return SPECIAL_LIST.contains(name);
    }

    public static boolean isArtist(UUID name) {
        return ARTIST_LIST.contains(name);
    }

    public static boolean isFriend(UUID name) {
        return FRIEND_LIST.contains(name);
    }

    public static void loadHatInformation() {
        CompletableFuture.supplyAsync(() -> {
            String urlString = "https://raw.githubusercontent.com/DivineRPG/DivineRPG-Assets/main/hats.json";
            try {
                HttpURLConnection con = (HttpURLConnection)new URL(urlString).openConnection();
                con.setConnectTimeout(1000);
                InputStream in2 = con.getInputStream();
                List lines = IOUtils.readLines((InputStream)in2, (Charset)Charset.defaultCharset());
                return String.join((CharSequence)"\n", lines);
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }).thenApply(rawJson -> {
            DEV_LIST.clear();
            TESTER_LIST.clear();
            SPECIAL_LIST.clear();
            ARTIST_LIST.clear();
            FRIEND_LIST.clear();
            if (rawJson != null) {
                try {
                    HatsInfo info = (HatsInfo)new Gson().fromJson(rawJson, HatsInfo.class);
                    if (info != null) {
                        DEV_LIST.addAll(info.dev);
                        TESTER_LIST.addAll(info.tester);
                        SPECIAL_LIST.addAll(info.special);
                        ARTIST_LIST.addAll(info.artists);
                        FRIEND_LIST.addAll(info.friend);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return rawJson;
        });
    }

    public static boolean bordersTar(BlockGetter world, int x, int y, int z) {
        for (int i = x - 4; i <= x + 4; ++i) {
            for (int j = y; j <= y + 1; ++j) {
                for (int k = z - 4; k <= z + 4; ++k) {
                    if (world.getBlockState(new BlockPos(i, j, k)).getBlock() != FluidRegistry.SMOLDERING_TAR_BLOCK.get()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void drop(Level level, Vec3 pos, @Nullable ItemStack item) {
        if (item != null) {
            level.addFreshEntity((Entity)new ItemEntity(level, pos.x, pos.y, pos.z, item));
        }
    }

    public static byte determineTimeOfDay(Level level) {
        if (level.dimension() == LevelRegistry.EDEN) {
            return 5;
        }
        if (level.dimension() == LevelRegistry.WILDWOOD) {
            return 0;
        }
        if (level.dimension() == LevelRegistry.APALACHIA) {
            return 1;
        }
        if (level.dimension() == LevelRegistry.SKYTHERN) {
            return 2;
        }
        if (level.dimension() == LevelRegistry.MORTUM) {
            return 5;
        }
        float timeOfDay = level.getTimeOfDay(1.0f);
        return (byte)(timeOfDay < 0.0625f ? 0 : (timeOfDay < 0.14f ? 1 : ((double)timeOfDay < 0.25 ? 2 : ((double)timeOfDay < 0.37 ? 3 : ((double)timeOfDay < 0.6 ? 4 : ((double)timeOfDay < 0.9 ? 5 : 0))))));
    }

    public static Block getBlock(String registryName) {
        return (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)registryName));
    }

    public static BlockState getBlockState(String registryName) {
        return ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)registryName))).defaultBlockState();
    }

    public static boolean hasEnchantment(ItemStack stack, HolderLookup.RegistryLookup<Enchantment> registry, ResourceKey<Enchantment> enchantment) {
        return stack.getEnchantmentLevel((Holder)registry.getOrThrow(enchantment)) != 0;
    }

    public static boolean isPotion(ItemStack stack, Holder<Potion> potion) {
        return (stack.is(Items.POTION) || stack.is(Items.SPLASH_POTION) || stack.is(Items.LINGERING_POTION)) && ((PotionContents)stack.get(DataComponents.POTION_CONTENTS)).is(potion);
    }

    public static BlockPos getNearbySpawnPos(ServerLevel level, RandomSource random, BlockPos position) {
        BlockState state;
        int x = position.getX() + random.nextInt(16) - 8;
        int z = position.getZ() + random.nextInt(16) - 8;
        int y = Surface.getSurface(Surface.Surface_Type.HIGHEST_GROUND, Surface.Mode.FULL, 64, 250, 1, (WorldGenLevel)level, random, x, z);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        while ((state = level.getBlockState((BlockPos)pos)).is(BlockTags.LEAVES) || state.is(BlockTags.SNOW)) {
            pos.move(Direction.DOWN);
        }
        do {
            pos.move(Direction.UP);
        } while (level.getBlockState((BlockPos)pos).is(BlockTags.SNOW));
        return pos;
    }

    public static BlockPos adjustHeight(ServerLevel level, BlockPos.MutableBlockPos pos) {
        while (!level.getBlockState((BlockPos)pos).isAir()) {
            pos.move(Direction.UP);
        }
        while (level.getBlockState((BlockPos)pos).isAir()) {
            pos.move(Direction.DOWN);
        }
        return pos.move(Direction.UP);
    }

    public static float rotlerp(float rot, float g, float bound) {
        float f1;
        float f = Mth.wrapDegrees((float)(g - rot));
        if (f > bound) {
            f = bound;
        }
        if (f < -bound) {
            f = -bound;
        }
        if ((f1 = rot + f) < 0.0f) {
            f1 += 360.0f;
        } else if (f1 > 360.0f) {
            f1 -= 360.0f;
        }
        return f1;
    }

    public static void awardAdvancement(MinecraftServer server, ServerPlayer player, ResourceLocation advancement, String criterion) {
        AdvancementProgress progress;
        AdvancementHolder adv = server.getAdvancements().get(advancement);
        if (adv != null && !(progress = player.getAdvancements().getOrStartProgress(adv)).isDone()) {
            progress.getRemainingCriteria().forEach(c -> {
                if (c.equals(criterion)) {
                    player.getAdvancements().award(adv, c);
                }
            });
        }
    }

    public static List<ServerPlayer> getNearbyPlayers(ServerLevel level, double x, double y, double z, double boxSize) {
        return level.getPlayers(p -> Math.abs(p.getX() - x) <= boxSize && Math.abs(p.getY() - y) <= boxSize && Math.abs(p.getZ() - z) <= boxSize);
    }

    public static int getEnchantmentLevel(ResourceKey<Enchantment> enchantment, ItemStack stack) {
        ItemEnchantments itemEnchantmentsComponent = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        for (Object2IntMap.Entry entry : itemEnchantmentsComponent.entrySet()) {
            if (!((Holder)entry.getKey()).is(enchantment)) continue;
            return entry.getIntValue();
        }
        return 0;
    }

    public static int getStoredEnchantmentLevel(ResourceKey<Enchantment> enchantment, ItemStack stack) {
        ItemEnchantments itemEnchantmentsComponent = (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        for (Object2IntMap.Entry entry : itemEnchantmentsComponent.entrySet()) {
            if (!((Holder)entry.getKey()).is(enchantment)) continue;
            return entry.getIntValue();
        }
        return 0;
    }

    public static boolean hasEnchantment(ResourceKey<Enchantment> enchantment, ItemStack stack) {
        ItemEnchantments itemEnchantmentsComponent = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        for (Object2IntMap.Entry entry : itemEnchantmentsComponent.entrySet()) {
            if (!((Holder)entry.getKey()).is(enchantment)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasStoredEnchantment(ResourceKey<Enchantment> enchantment, ItemStack stack) {
        ItemEnchantments itemEnchantmentsComponent = (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        for (Object2IntMap.Entry entry : itemEnchantmentsComponent.entrySet()) {
            if (!((Holder)entry.getKey()).is(enchantment)) continue;
            return true;
        }
        return false;
    }

    public static void summonEntityAt(ServerLevel level, EntityType<?> type, BlockPos pos, @Nullable Player player) {
        int y = Surface.getSurface(Surface.Surface_Type.LOWEST_GROUND, Surface.Mode.FULL, pos.getY() - 4, pos.getY() + 5, 0, (WorldGenLevel)level, level.getRandom(), pos.getX(), pos.getZ());
        if (level.getBlockStates(type.getSpawnAABB((double)(pos = new BlockPos(pos.getX(), y, pos.getZ())).getX() + 0.5, (double)pos.getY() + 0.14, (double)pos.getZ() + 0.5)).allMatch(BlockBehaviour.BlockStateBase::isAir)) {
            type.spawn(level, e -> {
                if (player != null) {
                    if (e instanceof EntityDivineNeutral) {
                        EntityDivineNeutral n = (EntityDivineNeutral)((Object)e);
                        n.setPersistentAngerTarget(player.getUUID());
                    } else if (e instanceof Mob) {
                        Mob l = (Mob)e;
                        l.setTarget((LivingEntity)player);
                    }
                }
            }, pos, MobSpawnType.TRIGGERED, true, false);
        }
    }

    public static class HatsInfo {
        public List<UUID> dev;
        public List<UUID> tester;
        public List<UUID> special;
        public List<UUID> artists;
        public List<UUID> friend;
    }
}

