/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.util;

import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;

public class LocalizeUtils {
    private static final String Ammo = "ammo";
    private static final String ArcanaConsuming = "arcana";
    private static final String ArcanaDamage = "damage.arcana";
    private static final String ArcanaRegen = "arcana.regen";
    private static final String BaseDamage = "damage.base";
    private static final String BowFasterPull = "bow_speed.faster";
    private static final String BowSlowerPull = "bow_speed.slower";
    private static final String BurnMobs = "effect.burns";
    private static final String Cool = "cool";
    private static final String Efficiency = "tool.efficiency";
    private static final String HarvestLevel = "tool.harvest_level";
    private static final String HealthHeal = "heals";
    private static final String HealthRegen = "health.regen";
    private static final String HitEnder = "hit_ender";
    private static final String InfiniteAmmo = "ammo.infinite";
    private static final String InstantConsumption = "instant_consumption";
    private static final String LessDrag = "less_drag";
    private static final String LightningShot = "lightning_shot";
    private static final String MagicDamage = "damage.magic";
    private static final String OnUseDamage = "damage.use";
    private static final String Poison = "effect.poisons";
    private static final String Pull = "pull";
    private static final String Push = "push";
    private static final String RangedDamage = "damage.ranged";
    private static final String ReturnsToSender = "return";
    private static final String ShootingPower = "ranged.power";
    private static final String ShotsBlinding = "shots.blind";
    private static final String ShotsBouncing = "shots.bounce";
    private static final String ShotsBurning = "shots.burn";
    private static final String ShotsExplosive = "shots.explosive";
    private static final String ShotsHoming = "shots.homing";
    private static final String ShotsSky = "shots.sky";
    private static final String ShotsSplit = "shots.split";
    private static final String SlowMobs = "effect.slows";
    private static final String Summoned = "summon";
    private static final String SummonedDamage = "summon.damage";
    private static final String SummonedDespawn = "summon.despawn";
    private static final String SummonedHealth = "summon.health";
    private static final String TeleportAttached = "effect.teleport";
    private static final String WeakenedWithoutArcana = "weakened_without_arcana";

    public static Component ammo(TagKey<Item> ammo) {
        MutableComponent ammoName = MutableComponent.create((ComponentContents)new TranslatableContents(Util.makeDescriptionId((String)"tag", (ResourceLocation)ammo.location()), null, new Object[0]));
        return LocalizeUtils.i18n(ChatFormatting.WHITE, Ammo, ammoName);
    }

    public static Component arcanaConsumed(Object arcana) {
        return LocalizeUtils.i18n(ChatFormatting.AQUA, ArcanaConsuming, arcana);
    }

    public static Component arcanaDam(Object damage) {
        return LocalizeUtils.i18n(ChatFormatting.DARK_AQUA, ArcanaDamage, damage);
    }

    public static Component arcanaRegen(int arcana) {
        return LocalizeUtils.i18n(ChatFormatting.AQUA, ArcanaRegen, arcana);
    }

    public static Component bouncingShots() {
        return LocalizeUtils.i18n(ChatFormatting.GOLD, ShotsBouncing, new Object[0]);
    }

    public static Component burn(int seconds) {
        return LocalizeUtils.i18n(ChatFormatting.DARK_RED, BurnMobs, seconds);
    }

    public static Component burningShots() {
        return LocalizeUtils.i18n(ChatFormatting.RED, ShotsBurning, new Object[0]);
    }

    public static Component efficiency(int eff) {
        return LocalizeUtils.i18n(ChatFormatting.WHITE, Efficiency, eff);
    }

    public static Component explosiveShots() {
        return LocalizeUtils.i18n(ChatFormatting.GOLD, ShotsExplosive, new Object[0]);
    }

    public static Component getClientSideTranslation(String string, Object ... argument) {
        return Component.translatable((String)string, (Object[])argument);
    }

    public static Component harvestLevel(Component lvl) {
        return LocalizeUtils.i18n(ChatFormatting.WHITE, HarvestLevel, lvl);
    }

    public static Component healthHeal(Object health) {
        return LocalizeUtils.i18n(ChatFormatting.RED, HealthHeal, health);
    }

    public static Component healthRegen(Object health) {
        return LocalizeUtils.i18n(ChatFormatting.RED, HealthRegen, health);
    }

    public static Component homingShots() {
        return LocalizeUtils.i18n(ChatFormatting.GOLD, ShotsHoming, new Object[0]);
    }

    public static Component infiniteAmmo() {
        return LocalizeUtils.i18n(ChatFormatting.BLUE, InfiniteAmmo, new Object[0]);
    }

    public static Component bowFasterPull(float speed) {
        return LocalizeUtils.i18n(ChatFormatting.DARK_GREEN, BowFasterPull, Float.valueOf(speed));
    }

    public static Component bowSlowerPull(float speed) {
        return LocalizeUtils.i18n(ChatFormatting.RED, BowSlowerPull, Float.valueOf(speed));
    }

    public static Component shootingPower(float power) {
        return LocalizeUtils.i18n(ChatFormatting.DARK_GREEN, ShootingPower, Float.valueOf(power));
    }

    public static Component baseDamage(int damage) {
        return LocalizeUtils.i18n(ChatFormatting.DARK_GREEN, BaseDamage, damage);
    }

    public static Component instantConsumption() {
        return LocalizeUtils.i18n(ChatFormatting.AQUA, InstantConsumption, new Object[0]);
    }

    public static Component lightningShots() {
        return LocalizeUtils.i18n(ChatFormatting.YELLOW, LightningShot, new Object[0]);
    }

    public static Component magicDam(Object damage) {
        return LocalizeUtils.i18n(ChatFormatting.DARK_PURPLE, MagicDamage, damage);
    }

    public static Component onUseDam(Object damage) {
        return LocalizeUtils.i18n(ChatFormatting.RED, OnUseDamage, damage);
    }

    public static Component poison(int seconds) {
        return LocalizeUtils.i18n(ChatFormatting.DARK_GREEN, Poison, seconds);
    }

    public static Component pull() {
        return LocalizeUtils.i18n(Pull, new Object[0]);
    }

    public static Component push() {
        return LocalizeUtils.i18n(Push, new Object[0]);
    }

    public static Component rangedDam(Object damage) {
        return LocalizeUtils.i18n(ChatFormatting.DARK_GREEN, RangedDamage, damage);
    }

    public static Component returnsToSender() {
        return LocalizeUtils.i18n(ReturnsToSender, new Object[0]);
    }

    public static Component slow(int seconds) {
        return LocalizeUtils.i18n(ChatFormatting.DARK_AQUA, SlowMobs, seconds);
    }

    public static Component blind(int seconds) {
        return LocalizeUtils.i18n(ChatFormatting.BLACK, ShotsBlinding, seconds);
    }

    public static Component cool() {
        return LocalizeUtils.i18n(ChatFormatting.AQUA, Cool, new Object[0]);
    }

    public static Component lessDrag() {
        return LocalizeUtils.i18n(ChatFormatting.DARK_GRAY, LessDrag, new Object[0]);
    }

    public static Component hitEnder() {
        return LocalizeUtils.i18n(ChatFormatting.DARK_PURPLE, HitEnder, new Object[0]);
    }

    public static Component teleportAttached() {
        return LocalizeUtils.i18n(ChatFormatting.LIGHT_PURPLE, TeleportAttached, new Object[0]);
    }

    public static Component splitShots(int count) {
        return LocalizeUtils.i18n(ChatFormatting.GOLD, ShotsSplit, count);
    }

    public static Component skyShots(Object count) {
        return LocalizeUtils.i18n(ChatFormatting.GOLD, ShotsSky, count);
    }

    public static Component summoned(EntityType<?> entity) {
        MutableComponent name = MutableComponent.create((ComponentContents)new TranslatableContents(entity.getDescriptionId(), null, new Object[0]));
        return LocalizeUtils.i18n(Summoned, name);
    }

    public static Component summonedDamage(int damage) {
        return LocalizeUtils.i18n(ChatFormatting.DARK_GREEN, SummonedDamage, damage);
    }

    public static Component summonedDespawn() {
        return LocalizeUtils.i18n(ChatFormatting.BLUE, SummonedDespawn, new Object[0]);
    }

    public static Component summonedHealth(int health) {
        return LocalizeUtils.i18n(ChatFormatting.RED, SummonedHealth, health);
    }

    public static Component weakenedWithoutArcana() {
        return LocalizeUtils.i18n(ChatFormatting.RED, WeakenedWithoutArcana, new Object[0]);
    }

    public static Component i18n(ChatFormatting color, String text, Object ... args) {
        if (args == null) {
            args = new Object[]{};
        }
        MutableComponent result = MutableComponent.create((ComponentContents)new TranslatableContents(String.format("tooltip.divinerpg.%s", text), null, args));
        return result.withStyle(color);
    }

    public static Component i18n(String text, Object ... args) {
        if (args == null) {
            args = new Object[]{};
        }
        MutableComponent result = MutableComponent.create((ComponentContents)new TranslatableContents(String.format("tooltip.divinerpg.%s", text), null, args));
        return result.withStyle(ChatFormatting.GRAY);
    }

    public static Component clientMessage(ChatFormatting color, String text, Object ... args) {
        if (args == null) {
            args = new Object[]{};
        }
        MutableComponent result = MutableComponent.create((ComponentContents)new TranslatableContents(String.format("message.divinerpg.%s", text), null, args));
        return result.withStyle(color);
    }

    public static Component clientMessage(String text, Object ... args) {
        if (args == null) {
            args = new Object[]{};
        }
        MutableComponent result = MutableComponent.create((ComponentContents)new TranslatableContents(String.format("message.divinerpg.%s", text), null, args));
        return result.withStyle(ChatFormatting.WHITE);
    }
}

