/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.registries;

import divinerpg.entities.base.EntityDivineMerchant;
import divinerpg.recipe.ArcaniumExtractorRecipe;
import divinerpg.recipe.FireConversionRecipe;
import divinerpg.recipe.InfusionTableRecipe;
import divinerpg.recipe.MaulSmashingRecipe;
import divinerpg.recipe.brewing.GrogRecipe;
import divinerpg.recipe.brewing.PotionOfLongWarmthRecipe;
import divinerpg.recipe.brewing.PotionOfWarmthRecipe;
import divinerpg.recipe.brewing.TeaRecipe;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.PotionRegistry;
import divinerpg.registries.TagRegistry;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class RecipeRegistry {
    @SubscribeEvent
    public void registerBrewingRecipes(RegisterBrewingRecipesEvent e) {
        e.getBuilder().addRecipe((IBrewingRecipe)new PotionOfWarmthRecipe());
        e.getBuilder().addRecipe((IBrewingRecipe)new PotionOfLongWarmthRecipe());
        e.getBuilder().addRecipe((IBrewingRecipe)new TeaRecipe());
        e.getBuilder().addRecipe((IBrewingRecipe)new GrogRecipe());
    }

    public static class Trades {
        public static final TradeGetter LIVESTOCK_MERCHANT = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(BlockRegistry.divineLog.toStack(16), ItemRegistry.shadow_coins.toStack(4), ItemRegistry.ehu_egg.toStack(2), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(BlockRegistry.divineLog.toStack(64), ItemRegistry.shadow_coins.toStack(7), ItemRegistry.husk_egg.toStack(2), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)Blocks.STONE, 64), ItemRegistry.shadow_coins.toStack(3), ItemRegistry.stone_golem_egg.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)Blocks.NETHER_BRICKS, 32), ItemRegistry.shadow_coins.toStack(5), ItemRegistry.smelter_egg.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.jungle_stone.toStack(2), ItemRegistry.shadow_coins.toStack(4), ItemRegistry.snapper_egg.toStack(3), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)Items.LEATHER, 10), ItemRegistry.shadow_coins.toStack(8), ItemRegistry.white_grizzle_egg.toStack(2), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)Items.LEATHER, 10), ItemRegistry.shadow_coins.toStack(8), ItemRegistry.brown_grizzle_egg.toStack(2), random.nextInt(7), 5)};
        public static final TradeGetter JACK_O_MAN = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)Items.BONE, 15), new ItemStack((ItemLike)Items.SPIDER_EYE, 5), ItemRegistry.skeleman_helmet.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)Items.BONE, 20), new ItemStack((ItemLike)Items.SPIDER_EYE, 10), ItemRegistry.skeleman_chestplate.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)Items.BONE, 20), new ItemStack((ItemLike)Items.SPIDER_EYE, 10), ItemRegistry.skeleman_leggings.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)Items.BONE, 15), new ItemStack((ItemLike)Items.SPIDER_EYE, 5), ItemRegistry.skeleman_boots.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)Blocks.PUMPKIN, 10), new ItemStack((ItemLike)Items.ENDER_PEARL, 1), ItemRegistry.jack_o_man_helmet.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)Blocks.PUMPKIN, 15), new ItemStack((ItemLike)Items.ENDER_PEARL, 2), ItemRegistry.jack_o_man_chestplate.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)Blocks.PUMPKIN, 15), new ItemStack((ItemLike)Items.ENDER_PEARL, 2), ItemRegistry.jack_o_man_leggings.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)Blocks.PUMPKIN, 10), new ItemStack((ItemLike)Items.ENDER_PEARL, 1), ItemRegistry.jack_o_man_boots.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)Items.SKELETON_SKULL, 1), ItemRegistry.wither_reaper_helmet.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)Items.SKELETON_SKULL, 1), ItemRegistry.wither_reaper_chestplate.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)Items.SKELETON_SKULL, 1), ItemRegistry.wither_reaper_leggings.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)Items.SKELETON_SKULL, 1), ItemRegistry.wither_reaper_boots.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)Items.BONE, 25), new ItemStack((ItemLike)Items.ENDER_PEARL, 4), ItemRegistry.scythe.toStack(), random.nextInt(7), 5)};
        public static final TradeGetter DIAMOND_DAVE = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)Items.DIAMOND, 16 + random.nextInt(8)), level == null || random.nextBoolean() ? ItemRegistry.realmite_pickaxe.toStack() : EnchantmentHelper.enchantItem((RandomSource)random, (ItemStack)ItemRegistry.realmite_pickaxe.toStack(), (int)random.nextInt(30), (RegistryAccess)level.registryAccess(), (Optional)level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getTag(EnchantmentTags.ON_TRADED_EQUIPMENT)), random.nextInt(3), 5), new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)Items.COAL, 8 + random.nextInt(2)), new ItemStack((ItemLike)Items.TORCH, 16), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)Items.RAW_IRON, 4), new ItemStack((ItemLike)Items.GLOW_BERRIES, 2 + random.nextInt(14)), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)Blocks.DEEPSLATE, 32 + random.nextInt(32)), new ItemStack((ItemLike)Items.ARROW, 16), random.nextInt(3), 5), new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)(random.nextBoolean() ? Items.DIAMOND : Items.EMERALD), 8 + random.nextInt(2)), PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.NIGHT_VISION), random.nextInt(2), 5), new EntityDivineMerchant.DivineTrades(new ItemStack((ItemLike)Items.COAL, 4 + random.nextInt(12)), BlockRegistry.divineLog.toStack(4 + random.nextInt(12)), random.nextInt(3), 5)};
        public static final TradeGetter WORKSHOP_MERCHANT = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(ItemRegistry.snowflake.toStack(6), ItemRegistry.seng_fur_helmet.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.snowflake.toStack(6), ItemRegistry.seng_fur_chestplate.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.snowflake.toStack(6), ItemRegistry.seng_fur_leggings.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.snowflake.toStack(6), ItemRegistry.seng_fur_boots.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.ice_stone.toStack(3), ItemRegistry.egg_nog.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.ice_stone.toStack(3), ItemRegistry.chocolate_log.toStack(5), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.ice_stone.toStack(3), ItemRegistry.peppermints.toStack(15), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.ice_stone.toStack(3), ItemRegistry.fruit_cake.toStack(3), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.snowflake.toStack(20), ItemRegistry.icicle_bane.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.ice_stone.toStack(3), BlockRegistry.greenFairyLights.toStack(16), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.ice_stone.toStack(3), BlockRegistry.redFairyLights.toStack(16), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.ice_stone.toStack(3), BlockRegistry.blueFairyLights.toStack(16), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.ice_stone.toStack(3), BlockRegistry.yellowFairyLights.toStack(16), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.ice_stone.toStack(3), BlockRegistry.purpleFairyLights.toStack(16), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.ice_stone.toStack(9), BlockRegistry.presentBox.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.ice_stone.toStack(3), BlockRegistry.blueCandyCane.toStack(4), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.ice_stone.toStack(3), BlockRegistry.greenCandyCane.toStack(4), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.ice_stone.toStack(3), BlockRegistry.pinkCandyCane.toStack(4), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.ice_stone.toStack(3), BlockRegistry.redCandyCane.toStack(4), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.ice_stone.toStack(3), BlockRegistry.yellowCandyCane.toStack(4), random.nextInt(7), 5)};
        public static final TradeGetter WORKSHOP_TINKERER = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(ItemRegistry.snowflake.toStack(), ItemRegistry.shuriken.toStack(16), ItemRegistry.snowflake_shuriken.toStack(16), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.snowflake.toStack(4), ItemRegistry.serenade_striker.toStack(), ItemRegistry.serenade_of_ice.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.snowflake.toStack(7), ItemRegistry.slime_sword.toStack(), ItemRegistry.glacier_sword.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.snowflake.toStack(12), ItemRegistry.shadow_bow.toStack(), ItemRegistry.icicle_bow.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.snowflake.toStack(6), ItemRegistry.massivence.toStack(), ItemRegistry.frossivence.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.snowflake.toStack(12), ItemRegistry.crabclaw_cannon.toStack(), ItemRegistry.frostclaw_cannon.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.snowflake.toStack(12), ItemRegistry.frost_cannon.toStack(), ItemRegistry.fractite_cannon.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.snowflake.toStack(15), ItemRegistry.frost_sword.toStack(), ItemRegistry.frostking_sword.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.snowflake.toStack(18), ItemRegistry.sound_of_music.toStack(), ItemRegistry.sound_of_carols.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.snowflake.toStack(25), ItemRegistry.ender_sword.toStack(), ItemRegistry.enderice.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.snowflake.toStack(30), ItemRegistry.soulfire_bow.toStack(), ItemRegistry.snowstorm_bow.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.snowflake.toStack(45), ItemRegistry.bedrock_maul.toStack(), ItemRegistry.frozen_maul.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.snowflake.toStack(40), ItemRegistry.divine_sword.toStack(), ItemRegistry.icine_sword.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.snowflake.toStack(15), ItemRegistry.sandslash.toStack(), ItemRegistry.snowslash.toStack(), random.nextInt(7), 5)};
        public static final TradeGetter GROGLIN_CHIEFTAIN = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(5), BlockRegistry.frostPumpkin.toStack(), random.nextInt(7), 3), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(25), ItemRegistry.seng_fur.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(7), PotionContents.createItemStack((Item)Items.POTION, PotionRegistry.GROG), random.nextInt(7), 2), new EntityDivineMerchant.DivineMapTrades(ItemRegistry.olivine.toStack(20), ItemRegistry.raw_wolpertinger_meat.toStack(5), "filled_map.groglin_raid_target", TagRegistry.RAID_TARGETS, (Holder<MapDecorationType>)MapDecorationTypes.TARGET_X, 15), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(), ItemRegistry.ice_stone.toStack(2), random.nextInt(7), 1), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(10), ItemRegistry.raw_wolpertinger_meat.toStack(2), ItemRegistry.sabear_sabre.toStack(), random.nextInt(7), 8)};
        public static final TradeGetter GROGLIN_HUNTER = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(24), ItemRegistry.seng_fur.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(12), ItemRegistry.raw_seng_meat.toStack(2), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(6), ItemRegistry.raw_wolpertinger_meat.toStack(5), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(10), ItemRegistry.cauldron_flesh.toStack(5), random.nextInt(7), 1), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(), ItemRegistry.ice_stone.toStack(3), random.nextInt(7), 1)};
        public static final TradeGetter GROGLIN_MERCHANT = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(20), BlockRegistry.iceLamp.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(3), ItemRegistry.winterberry.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(5), PotionContents.createItemStack((Item)Items.POTION, PotionRegistry.TEA), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(64), ItemRegistry.olivine.toStack(64), ItemRegistry.glacial_wall_totem.toStack(), random.nextInt(7), 25), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(15), ItemRegistry.raw_wolpertinger_meat.toStack(), ItemRegistry.armor_pouch.toStack(), random.nextInt(7), 5)};
        public static final TradeGetter GROGLIN_RANGER = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(3), BlockRegistry.glaconPumpkin.toStack(2), random.nextInt(7), 1), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(5), ItemRegistry.robbin_egg.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(PotionContents.createItemStack((Item)Items.POTION, PotionRegistry.GROG), ItemRegistry.olivine.toStack(), random.nextInt(7), 1), new EntityDivineMerchant.DivineTrades(ItemRegistry.raw_wolpertinger_meat.toStack(10), ItemRegistry.olivine.toStack(), random.nextInt(7), 1), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(), ItemRegistry.ice_stone.toStack(2), random.nextInt(7), 1)};
        public static final TradeGetter GROGLIN_SHARLATAN = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(6), PotionContents.createItemStack((Item)Items.POTION, PotionRegistry.GROG), random.nextInt(7), 2), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(4), PotionContents.createItemStack((Item)Items.POTION, PotionRegistry.TEA), random.nextInt(7), 2), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(15), PotionContents.createItemStack((Item)Items.POTION, PotionRegistry.LONG_WARMTH), random.nextInt(7), 2), new EntityDivineMerchant.DivineMapTrades(ItemRegistry.olivine.toStack(25), ItemRegistry.raw_wolpertinger_meat.toStack(5), "filled_map.whale_skull", TagRegistry.WHALE_SKULL, (Holder<MapDecorationType>)MapDecorationTypes.OCEAN_MONUMENT, 25), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(16), ItemRegistry.raw_wolpertinger_meat.toStack(4), BlockRegistry.frostedAllure.toStack(), random.nextInt(7), 8)};
        public static final TradeGetter GROGLIN_WARRIOR = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(12), BlockRegistry.snowBricks.toStack(8), random.nextInt(7), 1), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(14), ItemRegistry.raw_seng_meat.toStack(2), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(16), BlockRegistry.workshopCarpet.toStack(6), random.nextInt(7), 2), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(8), ItemRegistry.cauldron_flesh.toStack(5), random.nextInt(7), 1), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(), ItemRegistry.ice_stone.toStack(4), random.nextInt(7), 1)};
        public static final TradeGetter GRUZZORLUG_CANNONEER = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(10), BlockRegistry.workshopLamp.toStack(4), random.nextInt(7), 1), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(2), PotionContents.createItemStack((Item)Items.POTION, PotionRegistry.TEA), random.nextInt(7), 1), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(18), ItemRegistry.sabear_tooth.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(13), ItemRegistry.sabear_fur.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(), ItemRegistry.ice_stone.toStack(2), random.nextInt(7), 1)};
        public static final TradeGetter GRUZZORLUG_COMMANDER = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(), ItemRegistry.ice_shards.toStack(12), random.nextInt(7), 1), new EntityDivineMerchant.DivineMapTrades(ItemRegistry.olivine.toStack(25), ItemRegistry.raw_wolpertinger_meat.toStack(5), "filled_map.whale_skull", TagRegistry.WHALE_SKULL, (Holder<MapDecorationType>)MapDecorationTypes.OCEAN_MONUMENT, 25), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(8), BlockRegistry.icyBricks.toStack(4), random.nextInt(7), 1), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(10), BlockRegistry.frostedGlass.toStack(4), random.nextInt(7), 1), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(12), BlockRegistry.runicIcyBricks.toStack(4), random.nextInt(7), 1)};
        public static final TradeGetter GRUZZORLUG_GENERAL = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(12), BlockRegistry.workshopBookcase.toStack(3), random.nextInt(7), 3), new EntityDivineMerchant.DivineMapTrades(ItemRegistry.olivine.toStack(20), ItemRegistry.raw_wolpertinger_meat.toStack(5), "filled_map.gruzzorlug_raid_target", TagRegistry.GRUZZORLUG_RAID_TARGETS, (Holder<MapDecorationType>)MapDecorationTypes.TARGET_X, 15), new EntityDivineMerchant.DivineTrades(ItemRegistry.oxdrite_ingot.toStack(8), ItemRegistry.olivine.toStack(2), random.nextInt(7), 1), new EntityDivineMerchant.DivineTrades(ItemRegistry.anthracite.toStack(16), ItemRegistry.olivine.toStack(2), random.nextInt(7), 1), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(6), ItemRegistry.ice_stone.toStack(12), random.nextInt(7), 1)};
        public static final TradeGetter GRUZZORLUG_KNIGHT = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(8), ItemRegistry.winterberry.toStack(), random.nextInt(7), 1), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(4), PotionContents.createItemStack((Item)Items.POTION, PotionRegistry.TEA), random.nextInt(7), 1), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(14), ItemRegistry.raw_wolpertinger_meat.toStack(), ItemRegistry.sabear_tooth.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(10), ItemRegistry.raw_wolpertinger_meat.toStack(), ItemRegistry.sabear_fur.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(), ItemRegistry.ice_stone.toStack(3), random.nextInt(7), 1)};
        public static final TradeGetter GRUZZORLUG_MINER = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(ItemRegistry.oxdrite_pickaxe.toStack(), ItemRegistry.olivine.toStack(2), random.nextInt(7), 2), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(7), BlockRegistry.brittleMoss.toStack(), random.nextInt(7), 2), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(12), BlockRegistry.cobaltite.toStack(10), random.nextInt(7), 2), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(8), ItemRegistry.raw_oxdrite.toStack(2), random.nextInt(7), 1), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(4), ItemRegistry.anthracite.toStack(2), random.nextInt(7), 1)};
        public static final TradeGetter GRUZZORLUG_SWORDSMAN = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(16), ItemRegistry.sabear_tooth.toStack(), random.nextInt(7), 10), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(18), ItemRegistry.sabear_fur.toStack(), random.nextInt(7), 10), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(2), ItemRegistry.raw_wolpertinger_meat.toStack(4), random.nextInt(7), 1), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(5), PotionContents.createItemStack((Item)Items.POTION, PotionRegistry.TEA), random.nextInt(7), 1), new EntityDivineMerchant.DivineTrades(ItemRegistry.olivine.toStack(), ItemRegistry.ice_stone.toStack(4), random.nextInt(7), 1)};
        public static final TradeGetter CAPTAIN_MERIK = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(), ItemRegistry.grenade.toStack(10), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(10), ItemRegistry.korma_chestplate.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(10), ItemRegistry.korma_leggings.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(12), ItemRegistry.ender_scepter.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(12), ItemRegistry.firefly.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(20), ItemRegistry.captains_sparkler.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(20), ItemRegistry.ghostbane.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(5), ItemRegistry.storm_sword.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(6), ItemRegistry.korma_boots.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(6), ItemRegistry.korma_helmet.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(6), ItemRegistry.la_vekor.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(8), ItemRegistry.arcanium_saber.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(8), ItemRegistry.shadow_saber.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.dungeon_tokens.toStack(15), ItemRegistry.meriks_missile.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.dungeon_tokens.toStack(30), ItemRegistry.livicia_sword.toStack(), random.nextInt(7), 5)};
        public static final TradeGetter DATTICON = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(8), BlockRegistry.starBridge.toStack(16), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(8), BlockRegistry.slimeLight.toStack(16), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(2), BlockRegistry.arcaniteTubes.toStack(16), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(2), BlockRegistry.arcaniteLadder.toStack(16), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(2), BlockRegistry.moltenFurnace.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(3), BlockRegistry.greenlightFurnace.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(4), BlockRegistry.oceanfireFurnace.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(5), BlockRegistry.moonlightFurnace.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(7), BlockRegistry.whitefireFurnace.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(9), BlockRegistry.demonFurnace.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(3), BlockRegistry.elevantium.toStack(9), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(3), BlockRegistry.acceleron.toStack(3), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(), BlockRegistry.arcaniteLadder.toStack(8), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(6), ItemRegistry.korma_helmet.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(10), ItemRegistry.korma_chestplate.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(10), ItemRegistry.korma_leggings.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(6), ItemRegistry.korma_boots.toStack(), random.nextInt(7), 5)};
        public static final TradeGetter KAZARI = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(13), ItemRegistry.ancient_key.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(13), ItemRegistry.degraded_key.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(13), ItemRegistry.soul_key.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(13), ItemRegistry.sludge_key.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(2), BlockRegistry.ancientBricksBreakable.toStack(16), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(2), BlockRegistry.ancientStoneBreakable.toStack(16), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(2), BlockRegistry.ancientTileBreakable.toStack(16), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(2), BlockRegistry.arcaniumMetalBreakable.toStack(16), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(2), BlockRegistry.arcaniumPowerBreakable.toStack(4), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(2), BlockRegistry.degradedBricksBreakable.toStack(16), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(2), BlockRegistry.dungeonLampBreakable.toStack(4), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(2), BlockRegistry.soulSludgeBreakable.toStack(16), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(2), BlockRegistry.soulStoneBreakable.toStack(16), random.nextInt(7), 5)};
        public static final TradeGetter LEORNA = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(), ItemRegistry.eucalyptus_root_seeds.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(2), ItemRegistry.marsine_seeds.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(2), ItemRegistry.firestock_seeds.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(3), ItemRegistry.pinfly_seeds.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(4), ItemRegistry.aquamarine_seeds.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(5), ItemRegistry.hitchak_seeds.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(7), ItemRegistry.veilo_seeds.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(9), ItemRegistry.lamona_seeds.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(2), BlockRegistry.arcaniteDirt.toStack(16), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(2), BlockRegistry.arcaniteGrass.toStack(16), random.nextInt(7), 5)};
        public static final TradeGetter LORD_VATTICUS = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(), new ItemStack((ItemLike)Items.BLUE_DYE, 8), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(2), new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE, 12), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(2), BlockRegistry.soulSludgeBreakable.toStack(8), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(2), ItemRegistry.weak_arcana_potion.toStack(2), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(4), ItemRegistry.strong_arcana_potion.toStack(2), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(), new ItemStack((ItemLike)Items.BLAZE_ROD, 2), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(2), BlockRegistry.arcaniteMoss.toStack(8), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(2), ItemRegistry.wizards_book.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.collector.toStack(3), new ItemStack((ItemLike)Blocks.ENCHANTING_TABLE, 1), random.nextInt(7), 5)};
        public static final TradeGetter WAR_GENERAL = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(10), ItemRegistry.vemos_chestplate.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(10), ItemRegistry.vemos_leggings.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(18), ItemRegistry.arcanite_blaster.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(18), ItemRegistry.generals_staff.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(30), ItemRegistry.arcanite_blade.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(4), ItemRegistry.starlight.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(6), ItemRegistry.divine_accumulator.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(6), ItemRegistry.vemos_boots.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(6), ItemRegistry.vemos_helmet.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(7), ItemRegistry.arcanium_attractor.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(7), ItemRegistry.arcanium_reflector.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.dungeon_tokens.toStack(17), ItemRegistry.meteor_mash.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.dungeon_tokens.toStack(20), ItemRegistry.staff_of_starlight.toStack(), random.nextInt(7), 5)};
        public static final TradeGetter ZELUS = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(2), ItemRegistry.fyracryx_egg.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(3), ItemRegistry.seimer_egg.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(3), ItemRegistry.paratiku_egg.toStack(), random.nextInt(7), 5), new EntityDivineMerchant.DivineTrades(ItemRegistry.arcanium.toStack(5), ItemRegistry.golem_of_rejuvenation_egg.toStack(), random.nextInt(7), 5)};
        public static final TradeGetter THE_HUNGER = (level, random) -> new EntityDivineMerchant.DivineTrades[]{new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(), ItemRegistry.dream_carrot.toStack(2), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(3), ItemRegistry.dream_melon.toStack(4), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(5), ItemRegistry.dream_pie.toStack(5), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(10), ItemRegistry.dream_cake.toStack(8), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(10), ItemRegistry.dream_shovel.toStack(), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(10), ItemRegistry.dream_pickaxe.toStack(), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(10), ItemRegistry.dream_axe.toStack(), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(5), BlockRegistry.barredDoor.toStack(), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(3), ItemRegistry.disk_template.toStack(), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(5), ItemRegistry.dissipator_template.toStack(), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(3), ItemRegistry.cannon_template.toStack(), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(3), ItemRegistry.backsword_template.toStack(), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(3), ItemRegistry.hammer_template.toStack(), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(3), ItemRegistry.bow_template.toStack(), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(3), ItemRegistry.staff_template.toStack(), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(3), ItemRegistry.claw_template.toStack(), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(5), ItemRegistry.degraded_template.toStack(), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(), BlockRegistry.lightDreamBricks.toStack(16), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(), BlockRegistry.darkDreamBricks.toStack(16), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(), BlockRegistry.redDreamBricks.toStack(16), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(2), BlockRegistry.dreamDirt.toStack(64), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(), BlockRegistry.smoothGlass.toStack(16), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(4), BlockRegistry.firelight.toStack(), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(4), new ItemStack((ItemLike)Blocks.CHEST, 1), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(2), ItemRegistry.teaker_arrow.toStack(32), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.dirty_pearls.toStack(25), BlockRegistry.mortumBlock.toStack(4), random.nextInt(5), 1), new EntityDivineMerchant.DivineTrades(ItemRegistry.clean_pearls.toStack(), ItemRegistry.dream_sweets.toStack(4), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.clean_pearls.toStack(5), ItemRegistry.finished_template.toStack(), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.clean_pearls.toStack(2), ItemRegistry.darven_arrow.toStack(32), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.clean_pearls.toStack(4), ItemRegistry.pardimal_arrow.toStack(32), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.clean_pearls.toStack(6), ItemRegistry.karos_arrow.toStack(32), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.clean_pearls.toStack(15), ItemRegistry.miners_amulet.toStack(), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.polished_pearls.toStack(20), ItemRegistry.dream_flint.toStack(), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.polished_pearls.toStack(5), ItemRegistry.glistening_template.toStack(), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.polished_pearls.toStack(5), ItemRegistry.demonized_template.toStack(), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.shiny_pearls.toStack(40), ItemRegistry.moon_clock.toStack(), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.shiny_pearls.toStack(25), ItemRegistry.band_of_lheiva_hunting.toStack(), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.shiny_pearls.toStack(), ItemRegistry.dream_sours.toStack(4), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.shiny_pearls.toStack(4), ItemRegistry.ever_arrow.toStack(32), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.shiny_pearls.toStack(5), ItemRegistry.tormented_template.toStack(), random.nextInt(7), 0), new EntityDivineMerchant.DivineTrades(ItemRegistry.rock_chunks.toStack(25), ItemRegistry.karos_rockmaul.toStack(), random.nextInt(7), 0)};

        @FunctionalInterface
        public static interface TradeGetter {
            public EntityDivineMerchant.DivineTrades[] get(Level var1, RandomSource var2);
        }
    }

    public static class Serailizers {
        public static final DeferredRegister<RecipeSerializer<?>> SERIALIZER = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"divinerpg");
        public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<ArcaniumExtractorRecipe>> ARCANIUM_EXTRACTOR_SERIALIZER = SERIALIZER.register("arcanium_extractor", () -> new SimpleCookingSerializer(ArcaniumExtractorRecipe::new, 100));
        public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<InfusionTableRecipe>> INFUSION_TABLE_SERIALIZER = SERIALIZER.register("infusion_table", InfusionTableRecipe.Serializer::new);
        public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<MaulSmashingRecipe>> MAUL_SMASHING_SERIALIZER = SERIALIZER.register("maul_smashing", MaulSmashingRecipe.Serializer::new);
        public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<FireConversionRecipe>> FIRE_CONVERSION_SERIALIZER = SERIALIZER.register("fire_conversion", FireConversionRecipe.Serializer::new);
    }

    public static class Types {
        public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_TYPE, (String)"divinerpg");
        public static final DeferredHolder<RecipeType<?>, RecipeType<ArcaniumExtractorRecipe>> ARCANIUM_EXTRACTOR_RECIPE_TYPE = RECIPE_TYPES.register("arcanium_extractor", () -> ArcaniumExtractorRecipe.TYPE);
        public static final DeferredHolder<RecipeType<?>, RecipeType<InfusionTableRecipe>> INFUSIION_TABLE_RECIPE_TYPE = RECIPE_TYPES.register("infusion_table", () -> InfusionTableRecipe.TYPE);
        public static final DeferredHolder<RecipeType<?>, RecipeType<MaulSmashingRecipe>> MAUL_SMASHING = RECIPE_TYPES.register("maul_smashing", () -> MaulSmashingRecipe.TYPE);
        public static final DeferredHolder<RecipeType<?>, RecipeType<FireConversionRecipe>> FIRE_CONVERSION = RECIPE_TYPES.register("fire_conversion", () -> FireConversionRecipe.TYPE);
    }
}

