/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.registries;

import com.mojang.serialization.Codec;
import divinerpg.attachments.AttachedItem;
import divinerpg.attachments.DimensionalInventory;
import divinerpg.attachments.Reputation;
import divinerpg.attachments.base.ClientHandledAttachment;
import divinerpg.attachments.base.CommonHandledAttachment;
import divinerpg.attachments.base.ServerHandledAttachment;
import divinerpg.attachments.base.SingleSidedAttachment;
import divinerpg.config.CommonConfig;
import divinerpg.entities.base.FactionEntity;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class AttachmentRegistry {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"divinerpg");
    public static final DeferredHolder<AttachmentType<?>, AttachmentType<Integer>> SOUL_TRAP_COUNT = ATTACHMENT_TYPES.register("soul_trap_count", () -> AttachmentType.builder(() -> 0).serialize((Codec)Codec.INT).build());
    public static final SingleSidedAttachment<DimensionalInventory> DIMENSIONAL_INVENTORY = AttachmentRegistry.registerSingleSided("dimensional_inventory", DimensionalInventory::new, false);
    public static final SingleSidedAttachment<Integer> ANGER_TIME = AttachmentRegistry.registerSingleSided("anger_time", () -> 0, Codec.INT, false);
    public static final SingleSidedAttachment<Boolean> IMPORTANT = AttachmentRegistry.registerSingleSided("important", () -> false, Codec.BOOL, false);
    public static final ServerHandledAttachment<Float> ARCANA = AttachmentRegistry.registerServerHandled("arcana", () -> Float.valueOf(0.0f), Codec.FLOAT, ByteBufCodecs.FLOAT);
    public static final ServerHandledAttachment<Float> MAX_ARCANA = AttachmentRegistry.registerServerHandled("max_arcana", () -> Float.valueOf(CommonConfig.Values.ARCANA_MAX), Codec.FLOAT, ByteBufCodecs.FLOAT);
    public static final ServerHandledAttachment<Boolean> IN_DUNGEON = AttachmentRegistry.registerServerHandled("in_dungeon", () -> false, Codec.BOOL, ByteBufCodecs.BOOL);
    public static final ServerHandledAttachment<Boolean> ANGRY = AttachmentRegistry.registerServerHandled("angry", () -> false, Codec.BOOL, ByteBufCodecs.BOOL);
    public static final Reputation GROGLIN_REPUTATION = new Reputation("groglin_reputation", () -> FactionEntity.Faction.GROGLIN);
    public static final Reputation GRUZZORLUG_REPUTATION = new Reputation("gruzzorlug_reputation", () -> FactionEntity.Faction.GRUZZORLUG);
    public static final Reputation ICEIKA_MERCHANT_REPUTATION = new Reputation("iceika_merchant_reputation", () -> FactionEntity.Faction.ICEIKA_MERCHANT);
    public static final ServerHandledAttachment<Byte> VARIANT = AttachmentRegistry.registerServerHandled("variant", () -> (byte)0, Codec.BYTE, ByteBufCodecs.BYTE);
    public static final ServerHandledAttachment<Boolean> HANGING = AttachmentRegistry.registerServerHandled("hanging", () -> false, Codec.BOOL, ByteBufCodecs.BOOL);
    public static final ServerHandledAttachment<Boolean> SPECIAL = AttachmentRegistry.registerServerHandled("special", () -> false, Codec.BOOL, ByteBufCodecs.BOOL);
    public static final ServerHandledAttachment<Boolean> HOOKED = AttachmentRegistry.registerServerHandled("hooked", () -> false, Codec.BOOL, ByteBufCodecs.BOOL);
    public static final ServerHandledAttachment<AttachedItem> ITEM = AttachmentRegistry.registerServerHandled("item", AttachedItem::new, AttachedItem.CODEC);
    public static final ServerHandledAttachment<Float> RADIUS = AttachmentRegistry.registerServerHandled("radius", () -> Float.valueOf(0.0f), Codec.FLOAT, ByteBufCodecs.FLOAT);
    public static final CommonHandledAttachment<Integer> COLOR = AttachmentRegistry.registerCommonHandled("color", () -> 0xFF0000, Codec.INT, ByteBufCodecs.INT);

    private AttachmentRegistry() {
    }

    public static void registerPayloads(PayloadRegistrar r) {
        ARCANA.registerPayload(r);
        MAX_ARCANA.registerPayload(r);
        IN_DUNGEON.registerPayload(r);
        ANGRY.registerPayload(r);
        GROGLIN_REPUTATION.registerPayload(r);
        GRUZZORLUG_REPUTATION.registerPayload(r);
        ICEIKA_MERCHANT_REPUTATION.registerPayload(r);
        VARIANT.registerPayload(r);
        HANGING.registerPayload(r);
        SPECIAL.registerPayload(r);
        HOOKED.registerPayload(r);
        ITEM.registerPayload(r);
        RADIUS.registerPayload(r);
        COLOR.registerPayload(r);
    }

    public static <T> SingleSidedAttachment<T> registerSingleSided(String name, Supplier<T> defaultValue, Codec<T> codec, boolean clientSide) {
        return new SingleSidedAttachment<T>(name, defaultValue, codec, clientSide);
    }

    public static <B extends Tag, T extends INBTSerializable<B>> SingleSidedAttachment<T> registerSingleSided(String name, Supplier<T> defaultValue, boolean clientSide) {
        return new SingleSidedAttachment.Serializable(name, defaultValue, clientSide);
    }

    public static <T> ServerHandledAttachment<T> registerServerHandled(String name, Supplier<T> defaultValue, Codec<T> codec, StreamCodec<ByteBuf, T> streamCodec) {
        return new ServerHandledAttachment<T>(name, defaultValue, codec, streamCodec);
    }

    public static <B extends Tag, T extends INBTSerializable<B>> ServerHandledAttachment<T> registerServerHandled(String name, Supplier<T> defaultValue, StreamCodec<ByteBuf, T> streamCodec) {
        return new ServerHandledAttachment.Serializable(name, defaultValue, streamCodec);
    }

    public static <T> ClientHandledAttachment<T> registerClientHandled(String name, Supplier<T> defaultValue, Codec<T> codec, StreamCodec<ByteBuf, T> streamCodec) {
        return new ClientHandledAttachment<T>(name, defaultValue, codec, streamCodec);
    }

    public static <B extends Tag, T extends INBTSerializable<B>> ClientHandledAttachment<T> registerClientHandled(String name, Supplier<T> defaultValue, StreamCodec<ByteBuf, T> streamCodec) {
        return new ClientHandledAttachment.Serializable(name, defaultValue, streamCodec);
    }

    public static <T> CommonHandledAttachment<T> registerCommonHandled(String name, Supplier<T> defaultValue, Codec<T> codec, StreamCodec<ByteBuf, T> streamCodec) {
        return new CommonHandledAttachment<T>(name, defaultValue, codec, streamCodec);
    }

    public static <B extends Tag, T extends INBTSerializable<B>> CommonHandledAttachment<T> registerCommonHandled(String name, Supplier<T> defaultValue, StreamCodec<ByteBuf, T> streamCodec) {
        return new CommonHandledAttachment.Serializable(name, defaultValue, streamCodec);
    }
}

