/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.vethea;

import divinerpg.items.ranged.ItemThrowable;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.EntityRegistry;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ItemVetheanDissipator
extends ItemThrowable {
    public ItemVetheanDissipator(float damage) {
        super(new Item.Properties().stacksTo(1), () -> EntityRegistry.DISSIPATOR.value(), damage);
    }

    public static ArrayList<BlockPos> getLocalDungeonAir(Level level, BlockPos pos, float damage) {
        int area = (int)(damage / 3.0f);
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int x = pos.getX() - area; x < pos.getX() + area; ++x) {
            for (int y = pos.getY() - area; y < pos.getY() + area; ++y) {
                for (int z = pos.getZ() - area; z < pos.getZ() + area; ++z) {
                    BlockPos position = new BlockPos(x, y, z);
                    if (!level.getBlockState(position).is((Block)BlockRegistry.dungeonAir.get())) continue;
                    list.add(position);
                }
            }
        }
        return list;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        ArrayList<BlockPos> list = ItemVetheanDissipator.getLocalDungeonAir(level, context.getClickedPos(), this.damage);
        if (list.isEmpty()) {
            return InteractionResult.PASS;
        }
        for (BlockPos pos : list) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0, 0.1, 0.0);
            if (player.getRandom().nextInt(3) != 0) continue;
            level.playSound(player, pos, SoundEvents.CANDLE_EXTINGUISH, SoundSource.BLOCKS);
        }
        if (!player.isCreative()) {
            context.getItemInHand().hurtAndBreak(this.getDurabilityUse(context.getItemInHand()), (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
        }
        level.playSound(player, context.getClickedPos(), SoundEvents.BEE_LOOP, SoundSource.PLAYERS, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }
}

