/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.vanilla;

import divinerpg.items.base.ItemMod;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemSerenadeStriker
extends ItemMod {
    public ItemSerenadeStriker() {
        super(new Item.Properties().durability(100));
        this.cooldown = 80;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        int blockReachDistance = 32;
        Vec3 vec3d = player.getEyePosition(1.0f);
        Vec3 vec3d1 = player.getViewVector(1.0f);
        Vec3 vec3d2 = vec3d.add(vec3d1.x * (double)blockReachDistance, vec3d1.y * (double)blockReachDistance, vec3d1.z * (double)blockReachDistance);
        BlockHitResult pos = player.level().clip(new ClipContext(vec3d, vec3d2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        for (double angle = 0.0; angle < Math.PI; angle += 0.39269908169872414) {
            LightningBolt bolt = new LightningBolt(EntityType.LIGHTNING_BOLT, level);
            bolt.moveTo(pos.getLocation());
            level.addFreshEntity((Entity)bolt);
        }
        if (!player.isCreative()) {
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
        }
        player.getCooldowns().addCooldown((Item)this, this.cooldown);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.success((Object)stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.lightningShots());
        super.appendHoverText(stack, context, tooltip, flagIn);
    }
}

