/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.vanilla;

import divinerpg.entities.projectile.DivineThrowableProjectile;
import divinerpg.enums.ToolStats;
import divinerpg.items.base.ItemModSword;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemAnchor
extends ItemModSword {
    protected Supplier<EntityType<? extends DivineThrowableProjectile>> projectileType;
    int baseDamageTooltip;

    public ItemAnchor(ToolStats stats, Supplier<EntityType<? extends DivineThrowableProjectile>> projectileType, int baseDamageTooltip) {
        super(stats);
        this.projectileType = projectileType;
        this.baseDamageTooltip = baseDamageTooltip;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        player.playSound((SoundEvent)SoundRegistry.BLITZ.get(), 1.0f, 1.0f);
        if (!world.isClientSide) {
            Projectile bullet = (Projectile)this.projectileType.get().create(world);
            bullet.setOwner((Entity)player);
            bullet.setPos(player.getEyePosition().add(0.0, -0.15, 0.0));
            bullet.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 0.5f);
            world.addFreshEntity((Entity)bullet);
        }
        if (!player.isCreative()) {
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.consume((Object)stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.rangedDam(this.baseDamageTooltip));
        tooltip.add(LocalizeUtils.infiniteAmmo());
        super.appendHoverText(stack, context, tooltip, flagIn);
    }
}

