/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.vanilla;

import divinerpg.entities.base.EntityInserterMinecart;
import divinerpg.items.base.ItemMod;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class InserterMinecartItem
extends ItemMod {
    private static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack execute(BlockSource source, ItemStack stack) {
            double d3;
            RailShape railshape;
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            ServerLevel serverlevel = source.level();
            Vec3 vec3 = source.center();
            double d0 = vec3.x() + (double)direction.getStepX() * 1.125;
            double d1 = Math.floor(vec3.y()) + (double)direction.getStepY();
            double d2 = vec3.z() + (double)direction.getStepZ() * 1.125;
            BlockPos blockpos = source.pos().relative(direction);
            BlockState blockstate = serverlevel.getBlockState(blockpos);
            RailShape railShape = railshape = blockstate.getBlock() instanceof BaseRailBlock ? ((BaseRailBlock)blockstate.getBlock()).getRailDirection(blockstate, (BlockGetter)serverlevel, blockpos, null) : RailShape.NORTH_SOUTH;
            if (blockstate.is(BlockTags.RAILS)) {
                d3 = railshape.isAscending() ? 0.6 : 0.1;
            } else {
                if (!blockstate.isAir() || !serverlevel.getBlockState(blockpos.below()).is(BlockTags.RAILS)) {
                    return this.defaultDispenseItemBehavior.dispense(source, stack);
                }
                BlockState blockstate1 = serverlevel.getBlockState(blockpos.below());
                RailShape railshape1 = blockstate1.getBlock() instanceof BaseRailBlock ? ((BaseRailBlock)blockstate1.getBlock()).getRailDirection(blockstate1, (BlockGetter)serverlevel, blockpos.below(), null) : RailShape.NORTH_SOUTH;
                d3 = direction != Direction.DOWN && railshape1.isAscending() ? -0.4 : -0.9;
            }
            AbstractMinecart abstractminecart = InserterMinecartItem.createMinecart(serverlevel, d0, d1 + d3, d2, stack, null);
            serverlevel.addFreshEntity((Entity)abstractminecart);
            stack.shrink(1);
            return stack;
        }

        protected void playSound(BlockSource source) {
            source.level().levelEvent(1000, source.pos(), 0);
        }
    };

    public InserterMinecartItem() {
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)DISPENSE_ITEM_BEHAVIOR);
    }

    public static AbstractMinecart createMinecart(ServerLevel level, double x, double y, double z, ItemStack stack, @Nullable Player player) {
        EntityInserterMinecart abstractminecart = new EntityInserterMinecart((Level)level, x, y, z);
        EntityType.createDefaultStackConfig((ServerLevel)level, (ItemStack)stack, (Player)player).accept(abstractminecart);
        return abstractminecart;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockpos;
        Level level = context.getLevel();
        BlockState blockstate = level.getBlockState(blockpos = context.getClickedPos());
        if (!blockstate.is(BlockTags.RAILS)) {
            return InteractionResult.FAIL;
        }
        ItemStack itemstack = context.getItemInHand();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            RailShape railshape = blockstate.getBlock() instanceof BaseRailBlock ? ((BaseRailBlock)blockstate.getBlock()).getRailDirection(blockstate, (BlockGetter)level, blockpos, null) : RailShape.NORTH_SOUTH;
            double d0 = 0.0;
            if (railshape.isAscending()) {
                d0 = 0.5;
            }
            AbstractMinecart abstractminecart = InserterMinecartItem.createMinecart(serverlevel, (double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.0625 + d0, (double)blockpos.getZ() + 0.5, itemstack, context.getPlayer());
            serverlevel.addFreshEntity((Entity)abstractminecart);
            serverlevel.gameEvent((Holder)GameEvent.ENTITY_PLACE, blockpos, GameEvent.Context.of((Entity)context.getPlayer(), (BlockState)serverlevel.getBlockState(blockpos.below())));
        }
        itemstack.shrink(1);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

