/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.ranged.shooter;

import divinerpg.attachments.Arcana;
import divinerpg.items.ranged.ItemRangedWeapon;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class Shotgun
extends ItemRangedWeapon {
    public final int projectileCount;

    public Shotgun(@Nullable TagKey<Item> ammoType, Supplier<ItemStack> defaultItem, Supplier<EntityType<? extends Projectile>> projectileType, int uses, int cooldown, int projectileCount) {
        super(ammoType, defaultItem, projectileType, uses);
        this.cooldown = cooldown;
        this.projectileCount = projectileCount;
    }

    public Shotgun(Supplier<EntityType<? extends Projectile>> projectileType, int uses, int cooldown, int projectileCount) {
        super(null, () -> new ItemStack((ItemLike)Items.ARROW, projectileCount), projectileType, uses);
        this.cooldown = cooldown;
        this.projectileCount = projectileCount;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ItemStack ammo = this.findAmmo(player);
        if (ammo != null && !ammo.isEmpty() && ammo.getCount() > 0 && Arcana.getAmount((LivingEntity)player) >= (float)this.arcanaConsumedUse) {
            int count = Math.min(ammo.getCount(), this.projectileCount);
            if (!level.isClientSide) {
                for (int i = 0; i < count; ++i) {
                    this.shoot((ServerLevel)level, (LivingEntity)player, player.getUsedItemHand(), stack, List.of(ammo), this.power, 10.0f, false, null);
                }
                if (this.arcanaConsumedUse > 0) {
                    Arcana.modifyAmount((LivingEntity)player, -this.arcanaConsumedUse);
                }
            }
            ammo.consume(count, (LivingEntity)player);
            if (this.cooldown > 0) {
                player.getCooldowns().addCooldown((Item)this, this.cooldown);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.playSound(this.sound != null ? this.sound : SoundEvents.ARROW_SHOOT, 1.0f, 1.0f);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }
}

