/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.ranged.bows;

import divinerpg.entities.projectile.DivineArrow;
import divinerpg.entities.projectile.arrows.IcicleArrow;
import divinerpg.items.ranged.ItemBow;
import divinerpg.registries.ItemRegistry;
import divinerpg.util.LocalizeUtils;
import divinerpg.util.RarityList;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class IcicleBow
extends ItemBow {
    public final int effectSeconds;

    public IcicleBow() {
        super(new Item.Properties(), 1456, 24000, 1.0f, null, RarityList.ICICLE);
        this.effectSeconds = 4;
    }

    public AbstractArrow customArrow(AbstractArrow arrow, ItemStack projectileStack, ItemStack weaponStack) {
        AbstractArrow abstractArrow = arrow;
        Objects.requireNonNull(abstractArrow);
        AbstractArrow abstractArrow2 = abstractArrow;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IcicleArrow.class, Arrow.class, DivineArrow.class}, (Object)abstractArrow2, n)) {
            case 0: {
                IcicleArrow h = (IcicleArrow)abstractArrow2;
                h.powerMultiplier = 1.2f;
                h.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, this.effectSeconds * 20, 1));
                return arrow;
            }
            case 1: {
                Arrow a = (Arrow)abstractArrow2;
                IcicleBow.addEffect(a, new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, this.effectSeconds * 20, 1));
                break;
            }
            case 2: {
                DivineArrow a = (DivineArrow)abstractArrow2;
                a.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, this.effectSeconds * 20, 1));
                break;
            }
        }
        return arrow;
    }

    @Override
    public ItemStack getDefaultCreativeAmmo(@Nullable Player player, ItemStack projectileWeaponItem) {
        return new ItemStack((ItemLike)ItemRegistry.icicle_arrow.get());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add(LocalizeUtils.slow(this.effectSeconds));
    }
}

