/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.ranged.bows;

import divinerpg.entities.projectile.DivineArrow;
import divinerpg.entities.projectile.arrows.HunterArrow;
import divinerpg.items.ranged.ItemBow;
import divinerpg.registries.ItemRegistry;
import divinerpg.util.LocalizeUtils;
import divinerpg.util.RarityList;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class HunterBow
extends ItemBow {
    public final int effectSeconds;

    public HunterBow() {
        super(new Item.Properties(), 1125, 72000, 1.2f, null, RarityList.GREEN);
        this.effectSeconds = 2;
    }

    public AbstractArrow customArrow(AbstractArrow arrow, ItemStack projectileStack, ItemStack weaponStack) {
        AbstractArrow abstractArrow = arrow;
        Objects.requireNonNull(abstractArrow);
        AbstractArrow abstractArrow2 = abstractArrow;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HunterArrow.class, Arrow.class, DivineArrow.class}, (Object)abstractArrow2, n)) {
            case 0: {
                HunterArrow h = (HunterArrow)abstractArrow2;
                h.powerMultiplier = 1.2f;
                return arrow;
            }
            case 1: {
                Arrow a = (Arrow)abstractArrow2;
                HunterBow.addEffect(a, new MobEffectInstance(MobEffects.POISON, this.effectSeconds * 20, 3));
                break;
            }
            case 2: {
                DivineArrow a = (DivineArrow)abstractArrow2;
                a.addEffect(new MobEffectInstance(MobEffects.POISON, this.effectSeconds * 20, 3));
                break;
            }
        }
        return arrow;
    }

    @Override
    public ItemStack getDefaultCreativeAmmo(@Nullable Player player, ItemStack projectileWeaponItem) {
        return new ItemStack((ItemLike)ItemRegistry.hunter_arrow.get());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add(LocalizeUtils.poison(this.effectSeconds));
    }
}

