/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.ranged;

import divinerpg.attachments.Arcana;
import divinerpg.entities.projectile.DivineThrownItem;
import divinerpg.items.ranged.ItemThrowable;
import divinerpg.network.payload.AccurateSetMotionPacket;
import divinerpg.util.LocalizeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.network.PacketDistributor;

public class ItemRangedWeapon
extends ProjectileWeaponItem {
    public static final ResourceLocation GENERIC = ResourceLocation.withDefaultNamespace((String)"textures/particle/generic_0.png");
    public final TagKey<Item> ammoType;
    public SoundEvent sound;
    public float power = 3.0f;
    public int arcanaConsumedUse;
    public int cooldown;
    public final Supplier<EntityType<? extends Projectile>> projectileType;
    public Integer nameColor = null;
    protected boolean infinite;
    protected final List<Component> tooltips = new ArrayList<Component>();
    public final Supplier<ItemStack> defaultItem;

    public ItemRangedWeapon(Supplier<EntityType<? extends Projectile>> projectileType, int uses) {
        this(null, () -> ((Item)Items.ARROW).getDefaultInstance(), projectileType, uses);
    }

    protected ItemRangedWeapon(Item.Properties properties, Supplier<EntityType<? extends Projectile>> projectileType) {
        super(properties);
        this.ammoType = null;
        this.infinite = true;
        this.projectileType = projectileType;
        this.defaultItem = () -> ((Item)Items.ARROW).getDefaultInstance();
    }

    public ItemRangedWeapon(Supplier<EntityType<? extends Projectile>> projectileType) {
        this(null, () -> ((Item)Items.ARROW).getDefaultInstance(), projectileType);
    }

    public ItemRangedWeapon(@Nullable TagKey<Item> ammoType, Supplier<ItemStack> defaultItem, Supplier<EntityType<? extends Projectile>> projectileType) {
        super(new Item.Properties().component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)).stacksTo(1));
        this.ammoType = ammoType;
        this.infinite = ammoType == null;
        this.projectileType = projectileType;
        this.defaultItem = defaultItem;
    }

    public ItemRangedWeapon(@Nullable TagKey<Item> ammoType, Supplier<ItemStack> defaultItem, Supplier<EntityType<? extends Projectile>> projectileType, int uses) {
        super((uses == 0 ? new Item.Properties().component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)) : new Item.Properties().durability(uses)).stacksTo(1));
        this.ammoType = ammoType;
        this.infinite = ammoType == null;
        this.projectileType = projectileType;
        this.defaultItem = defaultItem;
    }

    public ItemRangedWeapon withTooltip(Component tip) {
        this.tooltips.add(tip);
        return this;
    }

    public ItemRangedWeapon withTooltips(List<Component> tooltip) {
        this.tooltips.addAll(tooltip);
        return this;
    }

    public ItemRangedWeapon withSound(SoundEvent s) {
        this.sound = s;
        return this;
    }

    public ItemRangedWeapon withPower(float pow) {
        this.power = pow;
        return this;
    }

    public ItemRangedWeapon withCooldown(int cooldown) {
        this.cooldown = cooldown;
        return this;
    }

    public ItemRangedWeapon arcanaUse(int arcana) {
        this.arcanaConsumedUse = arcana;
        return this;
    }

    public ItemRangedWeapon nameColor(int c) {
        this.nameColor = c;
        return this;
    }

    protected Projectile createProjectile(Level level, LivingEntity shooter, ItemStack weapon, ItemStack ammo, boolean isCrit) {
        Projectile p = (Projectile)this.projectileType.get().create(level);
        if (p instanceof DivineThrownItem) {
            DivineThrownItem t = (DivineThrownItem)p;
            t.setItem(ammo);
        }
        p.setOwner((Entity)shooter);
        p.setPos(shooter.getEyePosition().add(0.0, -0.147, 0.0));
        return p;
    }

    public ItemStack getDefaultCreativeAmmo(@Nullable Player player, ItemStack projectileWeaponItem) {
        return this.defaultItem.get();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ItemStack ammo = this.findAmmo(player);
        if (ammo != null && !ammo.isEmpty() && Arcana.getAmount((LivingEntity)player) >= (float)this.arcanaConsumedUse) {
            if (!level.isClientSide) {
                this.shoot((ServerLevel)level, (LivingEntity)player, player.getUsedItemHand(), stack, List.of(ammo), this.power, 1.0f, false, null);
                if (this.arcanaConsumedUse > 0) {
                    Arcana.modifyAmount((LivingEntity)player, -this.arcanaConsumedUse);
                }
            }
            ammo.consume(1, (LivingEntity)player);
            if (this.cooldown > 0) {
                player.getCooldowns().addCooldown((Item)this, this.cooldown);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            if (this instanceof ItemThrowable) {
                player.playSound(this.sound != null ? this.sound : SoundEvents.ARROW_SHOOT, 0.5f, 0.4f / (player.getRandom().nextFloat() * 0.4f + 0.8f));
                return InteractionResultHolder.success((Object)stack);
            }
            player.playSound(this.sound != null ? this.sound : SoundEvents.ARROW_SHOOT, 1.0f, 1.0f);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    protected ItemStack findAmmo(Player player) {
        ItemStack shootable = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (this.ammoType == null) {
            return this.getDefaultCreativeAmmo(player, shootable);
        }
        ItemStack itemstack = ProjectileWeaponItem.getHeldProjectile((LivingEntity)player, item -> item.is(this.ammoType));
        if (!itemstack.isEmpty()) {
            return CommonHooks.getProjectile((LivingEntity)player, (ItemStack)shootable, (ItemStack)itemstack);
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack itemstack1 = player.getInventory().getItem(i);
            if (!itemstack1.is(this.ammoType)) continue;
            return CommonHooks.getProjectile((LivingEntity)player, (ItemStack)shootable, (ItemStack)itemstack1);
        }
        return CommonHooks.getProjectile((LivingEntity)player, (ItemStack)shootable, (ItemStack)(player.getAbilities().instabuild ? this.getDefaultCreativeAmmo(player, shootable) : ItemStack.EMPTY));
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return this::isOfTag;
    }

    private boolean isOfTag(ItemStack stack) {
        return this.ammoType != null && stack.is(this.ammoType);
    }

    public int getDefaultProjectileRange() {
        return 15;
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int i, float velocity, float inaccuracy, float angle, @Nullable LivingEntity livingEntity1) {
        projectile.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot() + angle, 0.0f, velocity, inaccuracy);
    }

    protected void shoot(ServerLevel level, LivingEntity shooter, InteractionHand hand, ItemStack weapon, List<ItemStack> projectileItems, float velocity, float inaccuracy, boolean isCrit, @Nullable LivingEntity target) {
        float f = EnchantmentHelper.processProjectileSpread((ServerLevel)level, (ItemStack)weapon, (Entity)shooter, (float)0.0f);
        float f1 = projectileItems.size() == 1 ? 0.0f : 2.0f * f / (float)(projectileItems.size() - 1);
        float f2 = (float)((projectileItems.size() - 1) % 2) * f1 / 2.0f;
        float f3 = 1.0f;
        for (int i = 0; i < projectileItems.size(); ++i) {
            ItemStack itemstack = projectileItems.get(i);
            if (itemstack.isEmpty()) continue;
            float f4 = f2 + f3 * (float)(i + 1 >> 1) * f1;
            f3 = -f3;
            Projectile projectile = this.createProjectile((Level)level, shooter, weapon, itemstack, isCrit);
            this.shootProjectile(shooter, projectile, i, velocity, inaccuracy, f4, target);
            level.addFreshEntity((Entity)projectile);
            PacketDistributor.sendToPlayersTrackingEntity((Entity)projectile, (CustomPacketPayload)new AccurateSetMotionPacket(projectile.getId(), projectile.getDeltaMovement()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            weapon.hurtAndBreak(this.getDurabilityUse(itemstack), shooter, LivingEntity.getSlotForHand((InteractionHand)hand));
            if (weapon.isEmpty()) break;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.addAll(this.tooltips);
        if (this.arcanaConsumedUse > 0) {
            tooltip.add(LocalizeUtils.arcanaConsumed(this.arcanaConsumedUse));
        }
        if (this.infinite) {
            tooltip.add(LocalizeUtils.infiniteAmmo());
        } else if (this.ammoType != null) {
            tooltip.add(LocalizeUtils.ammo(this.ammoType));
        }
        super.appendHoverText(stack, context, tooltip, flagIn);
    }

    public Component getName(ItemStack pStack) {
        return this.nameColor != null ? ((MutableComponent)super.getName(pStack)).withColor(this.nameColor.intValue()) : super.getName(pStack);
    }
}

