/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.ranged;

import divinerpg.items.ranged.bows.EnderBow;
import divinerpg.items.ranged.bows.InfernoBow;
import divinerpg.network.payload.AccurateSetMotionPacket;
import divinerpg.util.LocalizeUtils;
import divinerpg.util.Utils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class ItemBow
extends BowItem {
    public final int useDuration;
    public final Integer nameColor;
    public final Supplier<Item> infinityArrow;
    public final float speedScale;

    public ItemBow(Item.Properties properties, int uses, int useDuration, float speedScale, Supplier<Item> infinityArrow, Integer nameColor) {
        super(uses == 0 ? properties.stacksTo(1).component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)) : properties.durability(uses));
        this.useDuration = useDuration;
        this.nameColor = nameColor;
        this.infinityArrow = infinityArrow;
        this.speedScale = speedScale;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return this.useDuration;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack;
        boolean flag = !player.getProjectile(itemstack = player.getItemInHand(hand)).isEmpty();
        InteractionResultHolder ret = EventHooks.onArrowNock((ItemStack)itemstack, (Level)level, (Player)player, (InteractionHand)hand, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        if (this.infinityArrow == null && !player.hasInfiniteMaterials() && !flag) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            ItemStack itemstack = player.getProjectile(stack);
            if (this.infinityArrow != null && (itemstack.isEmpty() || itemstack.is(this.infinityArrow.get()))) {
                itemstack = new ItemStack((ItemLike)this.infinityArrow.get());
            }
            if (itemstack.isEmpty()) {
                return;
            }
            int i = EventHooks.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)((this.getUseDuration(stack, entityLiving) - timeLeft) * 72000 / this.useDuration), (boolean)true);
            if (i < 0) {
                return;
            }
            float f = ItemBow.getPowerForTime((int)i);
            if (f >= 0.1f) {
                List list = ItemBow.draw((ItemStack)stack, (ItemStack)itemstack, (LivingEntity)player);
                if (level instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)level;
                    if (!list.isEmpty()) {
                        this.shoot(serverlevel, (LivingEntity)player, player.getUsedItemHand(), stack, list, f * 3.0f * this.speedScale, 1.0f, f == 1.0f, null);
                    }
                }
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    protected void shoot(ServerLevel level, LivingEntity shooter, InteractionHand hand, ItemStack weapon, List<ItemStack> projectileItems, float velocity, float inaccuracy, boolean isCrit, @Nullable LivingEntity target) {
        float f = EnchantmentHelper.processProjectileSpread((ServerLevel)level, (ItemStack)weapon, (Entity)shooter, (float)0.0f);
        float f1 = projectileItems.size() == 1 ? 0.0f : 2.0f * f / (float)(projectileItems.size() - 1);
        float f2 = (float)((projectileItems.size() - 1) % 2) * f1 / 2.0f;
        float f3 = 1.0f;
        for (int i = 0; i < projectileItems.size(); ++i) {
            ItemStack itemstack = projectileItems.get(i);
            if (itemstack.isEmpty()) continue;
            float f4 = f2 + f3 * (float)(i + 1 >> 1) * f1;
            f3 = -f3;
            Projectile projectile = this.createProjectile((Level)level, shooter, weapon, itemstack, isCrit);
            this.shootProjectile(shooter, projectile, i, velocity, inaccuracy, f4, target);
            level.addFreshEntity((Entity)projectile);
            PacketDistributor.sendToPlayersTrackingEntity((Entity)projectile, (CustomPacketPayload)new AccurateSetMotionPacket(projectile.getId(), projectile.getDeltaMovement()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            weapon.hurtAndBreak(this.getDurabilityUse(itemstack), shooter, LivingEntity.getSlotForHand((InteractionHand)hand));
            if (weapon.isEmpty()) break;
        }
    }

    public ItemStack getDefaultCreativeAmmo(@Nullable Player player, ItemStack projectileWeaponItem) {
        return new ItemStack((ItemLike)(this.infinityArrow == null ? Items.ARROW : (ItemLike)this.infinityArrow.get()));
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return super.supportsEnchantment(stack, enchantment) && (stack.has(DataComponents.MAX_DAMAGE) || !enchantment.is(Enchantments.MENDING) && !enchantment.is(Enchantments.UNBREAKING));
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return stack.has(DataComponents.MAX_DAMAGE) || !Utils.hasStoredEnchantment((ResourceKey<Enchantment>)Enchantments.MENDING, book) && !Utils.hasStoredEnchantment((ResourceKey<Enchantment>)Enchantments.UNBREAKING, book);
    }

    public static void addEffect(Arrow arrow, MobEffectInstance instance) {
        ItemStack stack = arrow.getPickupItemStackOrigin();
        PotionContents contents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        Iterable contentsit = contents.getAllEffects();
        for (MobEffectInstance c : contentsit) {
            if (!c.is(instance.getEffect())) continue;
            return;
        }
        stack.set(DataComponents.POTION_CONTENTS, (Object)contents.withEffectAdded(instance));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        float speed = 72000.0f / (float)this.useDuration;
        tooltip.add(LocalizeUtils.shootingPower(this.speedScale));
        if (speed > 1.0f) {
            tooltip.add(LocalizeUtils.bowFasterPull(speed));
        }
        if (speed < 1.0f) {
            tooltip.add(LocalizeUtils.bowSlowerPull(1.0f / speed));
        }
        if (this instanceof EnderBow) {
            tooltip.add(LocalizeUtils.teleportAttached());
        }
        if (this instanceof InfernoBow) {
            tooltip.add(LocalizeUtils.burningShots());
        }
        if (this.infinityArrow != null) {
            tooltip.add(LocalizeUtils.infiniteAmmo());
        }
        super.appendHoverText(stack, context, tooltip, flagIn);
    }

    public Component getName(ItemStack pStack) {
        return this.nameColor != null ? ((MutableComponent)super.getName(pStack)).withColor(this.nameColor.intValue()) : super.getName(pStack);
    }
}

