/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.iceika;

import divinerpg.registries.BlockRegistry;
import divinerpg.util.FoodList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ItemWinterberry
extends ItemNameBlockItem {
    public ItemWinterberry() {
        super((Block)BlockRegistry.winterberryBush.get(), new Item.Properties().food(FoodList.WINTERBERRY));
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockPos above = pos.above();
        BlockPos below = pos.below();
        Direction face = context.getClickedFace();
        Player player = context.getPlayer();
        if (level.getBlockState(pos).is((Block)BlockRegistry.brittleMoss.get()) && face.getAxis() == Direction.Axis.Y) {
            boolean b = face == Direction.UP && level.getBlockState(above).isAir();
            if (b) {
                level.setBlockAndUpdate(above, ((Block)BlockRegistry.winterberryBush.get()).defaultBlockState());
            } else {
                b = face == Direction.DOWN && level.getBlockState(below).isAir();
                if (b) {
                    level.setBlockAndUpdate(below, ((Block)BlockRegistry.winterberryVinesHead.get()).defaultBlockState());
                }
            }
            if (b) {
                context.getItemInHand().consume(1, (LivingEntity)player);
                level.playSound(player, pos, SoundEvents.SWEET_BERRY_BUSH_PLACE, SoundSource.BLOCKS);
                return InteractionResult.SUCCESS;
            }
        }
        return this.use(level, player, context.getHand()).getResult();
    }
}

