/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.arcana;

import divinerpg.attachments.Arcana;
import divinerpg.entities.projectile.bullet.EntityMerikMissile;
import divinerpg.items.base.ItemMod;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemMeriksMissile
extends ItemMod {
    public static final int MAX_USE_DURATION = 72000;

    public ItemMeriksMissile() {
        super(new Item.Properties().durability(1315));
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (!player.getAbilities().mayBuild) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity livingEntity, int timeLeft) {
        if (stack.getItem() == ItemRegistry.meriks_missile.get() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            float charge = (float)(72000 - timeLeft) / 20.0f;
            if (charge > 1.0f) {
                charge = 1.0f;
            }
            float arcanaPoints = 50.0f * charge;
            float finalCharge = charge;
            float amount = Arcana.getAmount((LivingEntity)player);
            if (amount >= arcanaPoints) {
                if ((double)finalCharge < 0.2) {
                    return;
                }
                float damage = Mth.clamp((float)(finalCharge * 25.0f), (float)2.0f, (float)8.0f);
                world.playSound(null, player.blockPosition(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f);
                EntityMerikMissile bullet = new EntityMerikMissile((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.MERIKS_MISSILE.get()), world, (LivingEntity)player, damage);
                bullet.moveTo(player.getX(), player.getY() + 1.0, player.getZ());
                bullet.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 3.0f, 1.0f);
                world.addFreshEntity((Entity)bullet);
                if (!world.isClientSide()) {
                    Arcana.modifyAmount((LivingEntity)player, -arcanaPoints);
                }
            }
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.rangedDam("2-8"));
        tooltip.add(LocalizeUtils.explosiveShots());
        tooltip.add(LocalizeUtils.homingShots());
        tooltip.add(LocalizeUtils.arcanaConsumed("10-50"));
    }
}

