/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events.enchant;

import divinerpg.registries.EnchantmentRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber(modid="divinerpg")
public class AftershockHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onHurt(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getDirectEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        int level = EnchantmentHelper.getEnchantmentLevel((Holder)entity.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(EnchantmentRegistry.AFTERSHOCK), (LivingEntity)livingEntity);
        if (level < 1) {
            return;
        }
        if (livingEntity.getRandom().nextInt(100) > level * 5) {
            return;
        }
        event.setNewDamage(event.getNewDamage() * 2.0f);
    }
}

