/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import divinerpg.attachments.Arcana;
import divinerpg.block_entities.block.TerranGhostBlockEntity;
import divinerpg.entities.goals.TurtleEatAequoreaGoal;
import divinerpg.entities.vanilla.overworld.EntityAequorea;
import divinerpg.network.payload.Weather;
import divinerpg.recipe.FireConversionRecipe;
import divinerpg.registries.AttachmentRegistry;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.DataComponentRegistry;
import divinerpg.registries.EnchantmentRegistry;
import divinerpg.registries.FluidRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.LevelRegistry;
import divinerpg.registries.MobEffectRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.registries.TagRegistry;
import divinerpg.util.Utils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class Ticker {
    public static int tick;

    @SubscribeEvent
    public void tickServer(ServerTickEvent.Pre evt) {
        if (evt.hasTime()) {
            if (++tick > 100000) {
                tick = 0;
            }
            if (Math.random() < 1.0E-4) {
                Utils.ICEIKA_WEATHER = Weather.newWeather(evt.getServer().getLevel(LevelRegistry.ICEIKA));
            }
        }
    }

    @SubscribeEvent
    public void playerTick(PlayerTickEvent.Pre event) {
        int f;
        Player player = event.getEntity();
        Level level = player.level();
        if (!level.isClientSide()) {
            Arcana.regen((LivingEntity)player);
        }
        if (level.dimension() == LevelRegistry.ICEIKA) {
            if (!level.isClientSide() && (player.tickCount & 7) == 0) {
                AttachmentRegistry.IN_DUNGEON.set((Entity)player, ((ServerLevel)level).structureManager().getStructureWithPieceAt(player.blockPosition(), TagRegistry.ICEIKA_DUNGEON).isValid());
            }
            if (!player.isCreative() && !player.isSpectator()) {
                if (Utils.ICEIKA_WEATHER == 1 && level.isRaining() && player.getItemBySlot(EquipmentSlot.HEAD).isEmpty() && player.getRandom().nextFloat() < 0.1f && level.canSeeSky(player.blockPosition())) {
                    player.hurt(level.damageSources().generic(), 1.0f);
                }
                if (!(level.isClientSide() || player.hasEffect(MobEffectRegistry.WARMTH) || player.getItemBySlot(EquipmentSlot.CHEST).getTagEnchantments().keySet().contains(level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(EnchantmentRegistry.INSULATION)) || level.getLightEngine().getLayerListener(LightLayer.BLOCK).getLightValue(player.blockPosition()) >= 8)) {
                    player.setSharedFlagOnFire(false);
                    if (player.isFullyFrozen()) {
                        player.setTicksFrozen(player.getTicksRequiredToFreeze() + 2);
                        if (player.getHealth() > 1.0f && player.tickCount % 40 == 0) {
                            player.hurt(level.damageSources().freeze(), 0.5f);
                        }
                    } else {
                        player.setTicksFrozen(player.getTicksFrozen() + 2 + player.getRandom().nextInt(2) + (Utils.ICEIKA_WEATHER == 2 ? player.getRandom().nextInt(2) : 0));
                    }
                }
            }
        }
        if (player.getItemBySlot(EquipmentSlot.CHEST).getAllEnchantments(CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT)).keySet().contains(level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(EnchantmentRegistry.INSULATION)) && (f = player.getTicksFrozen()) > 0) {
            player.setTicksFrozen(f - 2);
        }
    }

    @SubscribeEvent
    public void addVanillaMobGoals(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Turtle) {
            Turtle turtle = (Turtle)entity;
            turtle.goalSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)turtle, EntityAequorea.class, false));
            turtle.goalSelector.addGoal(3, (Goal)new TurtleEatAequoreaGoal(turtle, turtle.getAttributeValue(Attributes.FOLLOW_RANGE), false));
        }
    }

    @SubscribeEvent
    public void onMineBlock(BlockEvent.BreakEvent event) {
        if (Ticker.handleTerranShifter(event.getLevel(), event.getPlayer(), event.getPos(), event.getState(), event.getPlayer().getMainHandItem())) {
            event.setCanceled(true);
        }
    }

    public static boolean handleTerranShifter(LevelAccessor level, Player player, BlockPos pos, BlockState state, ItemStack tool) {
        if (tool.is(ItemRegistry.terran_shifter) && !state.is(BlockRegistry.terranGhostBlock)) {
            level.setBlock(pos, ((Block)BlockRegistry.terranGhostBlock.get()).defaultBlockState(), 3);
            ((TerranGhostBlockEntity)level.getBlockEntity((BlockPos)pos)).originalState = state;
            tool.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onEntityLeave(EntityLeaveLevelEvent event) {
        ItemEntity i;
        Entity entity;
        if (!event.getLevel().isClientSide && (entity = event.getEntity()) instanceof ItemEntity && (i = (ItemEntity)entity).getAge() < i.lifespan) {
            BlockPos[] positions;
            ItemStack stack = i.getItem();
            if (stack.isEmpty()) {
                return;
            }
            ServerLevel level = (ServerLevel)event.getLevel();
            List<FireConversionRecipe> recipes = level.getRecipeManager().getAllRecipesFor(FireConversionRecipe.TYPE).stream().filter(r -> ((FireConversionRecipe)r.value()).inputItem().test(stack)).map(RecipeHolder::value).toList();
            if (recipes.isEmpty()) {
                return;
            }
            BlockPos pos = i.blockPosition();
            for (BlockPos position : positions = new BlockPos[]{pos, pos.below(), pos.north(), pos.east(), pos.south(), pos.west(), pos.offset(1, 0, 1), pos.offset(1, 0, -1), pos.offset(-1, 0, 1), pos.offset(-1, 0, -1)}) {
                BlockState state;
                BlockState prevState = state = level.getBlockState(position);
                if (state.isAir()) continue;
                for (FireConversionRecipe recipe : recipes) {
                    ItemStack output;
                    if (!recipe.inputState().test(state, level.random)) continue;
                    if (recipe.outputState().isPresent()) {
                        state = recipe.outputState().get().getState(level.getRandom(), position);
                        level.setBlock(position, state, 3);
                    }
                    if (recipe.outputItem().isPresent() && !(output = recipe.outputItem().get().copy()).isEmpty()) {
                        if (output.is(ItemRegistry.frozen_clock)) {
                            output.set(DataComponentRegistry.variant, (Object)Utils.determineTimeOfDay((Level)level));
                        }
                        output.setCount(output.getCount() * stack.getCount());
                        ItemEntity itemEntity = new ItemEntity((Level)level, i.getX(), i.getY(), i.getZ(), output);
                        itemEntity.setDefaultPickUpDelay();
                        itemEntity.setDeltaMovement(i.getDeltaMovement());
                        level.addFreshEntity((Entity)itemEntity);
                    }
                    if (recipe.advancement().isPresent()) {
                        List<ServerPlayer> players = Utils.getNearbyPlayers(level, i.getX(), i.getY(), i.getZ(), 9.0);
                        for (ServerPlayer player : players) {
                            Utils.awardAdvancement(level.getServer(), player, recipe.advancement().get(), recipe.advancementCriteria().orElse("impossible"));
                        }
                    }
                    if (state.isAir()) {
                        if (prevState.is(BlockRegistry.icyFire)) {
                            level.playSound(null, position, (SoundEvent)SoundRegistry.FREEZE.get(), SoundSource.BLOCKS, 0.8f, 1.5f);
                        } else if (prevState.is(BlockRegistry.enchantedFlame)) {
                            level.playSound(null, position, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 0.8f, 1.2f);
                            level.playSound(null, position, SoundEvents.ENDERMAN_TELEPORT, SoundSource.BLOCKS, 0.8f, 1.0f);
                        } else if (prevState.is(BlockTags.FIRE)) {
                            level.playSound(null, position, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS);
                        } else if (prevState.getFluidState().is((Fluid)FluidRegistry.SMOLDERING_TAR_FLUID.get())) {
                            level.playSound(null, position, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
                            level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, i.getX(), i.getY(), i.getZ(), 25, 0.5, 0.5, 0.5, 0.01);
                        }
                    } else if (state.is(BlockRegistry.icyFire)) {
                        if (prevState.is(BlockRegistry.icyFire)) {
                            level.playSound(null, position, (SoundEvent)SoundRegistry.FREEZE.get(), SoundSource.BLOCKS, 0.8f, 1.5f);
                        } else {
                            level.playSound(null, position, (SoundEvent)SoundRegistry.FREEZE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                    } else if (state.is(BlockRegistry.hellFire)) {
                        level.sendParticles((ParticleOptions)ParticleTypes.SOUL, i.getX(), i.getY(), i.getZ(), 4, 0.2, 0.2, 0.2, 0.0);
                        level.playSound(null, position, SoundEvents.SCULK_SHRIEKER_SHRIEK, SoundSource.BLOCKS, 0.7f, 1.5f);
                        level.playSound(null, position, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else if (state.is(BlockRegistry.divineFlame) || state.is(BlockRegistry.wildFlame) || state.is(BlockRegistry.enchantedFlame) || state.is(BlockRegistry.skyFire) || state.is(BlockRegistry.mortumEmbers)) {
                        level.playSound(null, position, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.playSound(null, position, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    return;
                }
            }
        }
    }
}

