/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import divinerpg.entities.eden.EntityWeakCori;
import divinerpg.entities.vanilla.overworld.EntityCaveclops;
import divinerpg.entities.vanilla.overworld.EntityEnthralledDramcryx;
import divinerpg.entities.vanilla.overworld.EntityJackOMan;
import divinerpg.entities.vanilla.overworld.EntityKobblin;
import divinerpg.entities.vanilla.overworld.EntitySaguaroWorm;
import divinerpg.registries.AttachmentRegistry;
import divinerpg.registries.EntityRegistry;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;

public class SpawnEvents {
    public static final ResourceKey<Biome> BONEYARD = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"iceika/boneyard"));
    public static final ResourceKey<Biome> BOREALIS_STEEPS = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"iceika/borealis_steeps"));
    public static final ResourceKey<Biome> CHILL_PASSAGE = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"iceika/chill_passage"));
    public static final ResourceKey<Biome> CHILLY_CAVERN = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"iceika/chilly_cavern"));
    public static final ResourceKey<Biome> COZYBARK_FOREST = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"iceika/cozybark_forest"));
    public static final ResourceKey<Biome> DEEP_FROZEN_OCEAN = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"iceika/deep_frozen_ocean"));
    public static final ResourceKey<Biome> FRACTAL_FOREST = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"iceika/fractal_forest"));
    public static final ResourceKey<Biome> FROZEN_MENAGERIE = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"iceika/frozen_menagerie"));
    public static final ResourceKey<Biome> FROZEN_OCEAN = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"iceika/frozen_ocean"));
    public static final ResourceKey<Biome> FROZEN_PEAKS = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"iceika/frozen_peaks"));
    public static final ResourceKey<Biome> GEYSER_PLATEAU = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"iceika/geyser_pateau"));
    public static final ResourceKey<Biome> GLOWING_DEEP = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"iceika/glowing_deep"));
    public static final ResourceKey<Biome> ICE_SHEET = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"iceika/ice_sheet"));
    public static final ResourceKey<Biome> ICE_SPIKES = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"iceika/ice_spikes"));
    public static final ResourceKey<Biome> MORGUE_MARSH = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"iceika/morgue_marsh"));
    public static final ResourceKey<Biome> SHELTERED_GARDEN = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"iceika/sheltered_garden"));
    public static final ResourceKey<Biome> SHIVERSPINE_FOREST = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"iceika/shiverspine_forest"));
    public static final ResourceKey<Biome> SNOW_BOG = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"iceika/snow_bog"));
    public static final ResourceKey<Biome> SNOWY_PEAKS = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"iceika/snowy_peaks"));
    public static final ResourceKey<Biome> THERMAL_VENTS = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"iceika/thermal_vents"));
    public static final ResourceKey<Biome> TUNDRA = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"iceika/tundra"));
    public static final SpawnPlacementType ON_BLOCK = new SpawnPlacementType(){

        public boolean isSpawnPositionOk(LevelReader level, BlockPos pos, @Nullable EntityType<?> entityType) {
            pos = pos.below();
            BlockState state = level.getBlockState(pos);
            return entityType != null && level.getWorldBorder().isWithinBounds(pos) && (Block.isFaceFull((VoxelShape)state.getCollisionShape((BlockGetter)level, pos), (Direction)Direction.UP) || state.is(Blocks.SNOW)) && !state.is(Blocks.ICE);
        }

        public BlockPos adjustSpawnPosition(LevelReader level, BlockPos pos) {
            BlockState state;
            BlockPos.MutableBlockPos mut = pos.mutable();
            while (Block.isFaceFull((VoxelShape)(state = level.getBlockState((BlockPos)mut)).getCollisionShape((BlockGetter)level, (BlockPos)mut), (Direction)Direction.UP) || state.is(Blocks.SNOW)) {
                mut.move(Direction.UP);
            }
            return mut;
        }
    };
    private static final EnumMap<Difficulty, Integer> cancellationChances = new EnumMap<Difficulty, Integer>(Map.of(Difficulty.PEACEFUL, 11, Difficulty.EASY, 6, Difficulty.NORMAL, 4, Difficulty.HARD, 0));
    public static final SpawnPlacements.SpawnPredicate<? extends Entity> ALWAYS = (e, s, t, p, r) -> true;
    public static final SpawnPlacements.SpawnPredicate<? extends Entity> DIFFICULTY_FILTER = SpawnEvents::difficultyFilter;
    public static final SpawnPlacements.SpawnPredicate<? extends Entity> MOB = SpawnEvents::checkMobSpawnRules;
    public static final SpawnPlacements.SpawnPredicate<? extends Entity> MONSTER = (e, s, t, p, r) -> SpawnEvents.difficultyFilter((EntityType<? extends Entity>)e, s, t, p, r) && SpawnEvents.checkMobSpawnRules((EntityType<? extends Entity>)e, (LevelAccessor)s, t, p, r);
    public static final SpawnPlacements.SpawnPredicate<? extends Entity> DARKNESS = (e, s, t, p, r) -> Monster.isDarkEnoughToSpawn((ServerLevelAccessor)s, (BlockPos)p, (RandomSource)r) && SpawnEvents.checkMobSpawnRules((EntityType<? extends Entity>)e, (LevelAccessor)s, t, p, r);
    public static final SpawnPlacements.SpawnPredicate<? extends Entity> MONSTER_DARKNESS = (e, s, t, p, r) -> SpawnEvents.difficultyFilter((EntityType<? extends Entity>)e, s, t, p, r) && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)s, (BlockPos)p, (RandomSource)r) && SpawnEvents.checkMobSpawnRules((EntityType<? extends Entity>)e, (LevelAccessor)s, t, p, r);
    public static final SpawnPlacements.SpawnPredicate<? extends Entity> DARKNESS_AGILE = (e, s, t, p, r) -> Monster.isDarkEnoughToSpawn((ServerLevelAccessor)s, (BlockPos)p, (RandomSource)r);
    public static final SpawnPlacements.SpawnPredicate<? extends Entity> MONSTER_DARKNESS_AGILE = (e, s, t, p, r) -> SpawnEvents.difficultyFilter((EntityType<? extends Entity>)e, s, t, p, r) && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)s, (BlockPos)p, (RandomSource)r);
    public static final SpawnPlacements.SpawnPredicate<? extends Entity> CAVE_MONSTER = (en, s, t, p, r) -> p.getY() < 60 && SpawnEvents.difficultyFilter((EntityType<? extends Entity>)en, s, t, p, r) && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)s, (BlockPos)p, (RandomSource)r) && SpawnEvents.checkMobSpawnRules((EntityType<? extends Entity>)en, (LevelAccessor)s, t, p, r);
    public static final SpawnPlacements.SpawnPredicate<? extends Entity> DEEPSLATE_MONSTER = (en, s, t, p, r) -> p.getY() < 0 && SpawnEvents.difficultyFilter((EntityType<? extends Entity>)en, s, t, p, r) && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)s, (BlockPos)p, (RandomSource)r) && SpawnEvents.checkMobSpawnRules((EntityType<? extends Entity>)en, (LevelAccessor)s, t, p, r);
    public static final SpawnPlacements.SpawnPredicate<? extends Entity> AGILE_UNDER_SKY = (e, s, t, p, r) -> s.canSeeSky(p);
    public static final SpawnPlacements.SpawnPredicate<? extends Entity> MONSTER_AGILE_UNDER_SKY = (e, s, t, p, r) -> SpawnEvents.difficultyFilter((EntityType<? extends Entity>)e, s, t, p, r) && s.canSeeSky(p);
    public static final SpawnPlacements.SpawnPredicate<? extends Entity> MOB_UNDER_SKY = (e, s, t, p, r) -> SpawnEvents.checkMobSpawnRules((EntityType<? extends Entity>)e, (LevelAccessor)s, t, p, r) && s.canSeeSky(p);
    public static final SpawnPlacements.SpawnPredicate<? extends Entity> MONSTER_UNDER_SKY = (e, s, t, p, r) -> SpawnEvents.difficultyFilter((EntityType<? extends Entity>)e, s, t, p, r) && SpawnEvents.checkMobSpawnRules((EntityType<? extends Entity>)e, (LevelAccessor)s, t, p, r) && s.canSeeSky(p);
    public static final SpawnPlacements.SpawnPredicate<? extends Entity> DARKNESS_UNDER_SKY = (e, s, t, p, r) -> Monster.isDarkEnoughToSpawn((ServerLevelAccessor)s, (BlockPos)p, (RandomSource)r) && SpawnEvents.checkMobSpawnRules((EntityType<? extends Entity>)e, (LevelAccessor)s, t, p, r) && s.canSeeSky(p);
    public static final SpawnPlacements.SpawnPredicate<? extends Entity> MONSTER_DARKNESS_UNDER_SKY = (e, s, t, p, r) -> SpawnEvents.difficultyFilter((EntityType<? extends Entity>)e, s, t, p, r) && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)s, (BlockPos)p, (RandomSource)r) && SpawnEvents.checkMobSpawnRules((EntityType<? extends Entity>)e, (LevelAccessor)s, t, p, r) && s.canSeeSky(p);
    public static final SpawnPlacements.SpawnPredicate<? extends Entity> DARKNESS_AGILE_UNDER_SKY = (e, s, t, p, r) -> Monster.isDarkEnoughToSpawn((ServerLevelAccessor)s, (BlockPos)p, (RandomSource)r) && s.canSeeSky(p);
    public static final SpawnPlacements.SpawnPredicate<? extends Entity> MONSTER_DARKNESS_AGILE_UNDER_SKY = (e, s, t, p, r) -> SpawnEvents.difficultyFilter((EntityType<? extends Entity>)e, s, t, p, r) && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)s, (BlockPos)p, (RandomSource)r) && s.canSeeSky(p);

    @SubscribeEvent
    public static void spawnPlacementCheck(MobSpawnEvent.SpawnPlacementCheck e) {
        ServerLevelAccessor serverLevelAccessor = e.getLevel();
        if (serverLevelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)serverLevelAccessor;
            MobSpawnType type = e.getSpawnType();
            if ((type == MobSpawnType.NATURAL || type == MobSpawnType.STRUCTURE || type == MobSpawnType.PATROL) && (Integer)level.getChunkAt(e.getPos()).getData(AttachmentRegistry.SOUL_TRAP_COUNT) > 0) {
                e.setResult(MobSpawnEvent.SpawnPlacementCheck.Result.FAIL);
            }
        }
    }

    @SubscribeEvent
    public static void registerSpawnPlacements(RegisterSpawnPlacementsEvent e) {
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.AYERACO.get()), SpawnType.FLY, ALWAYS);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.AEQUOREA.get()), SpawnType.WATER, DIFFICULTY_FILTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.ARID_WARRIOR.get()), SpawnType.GROUND, MONSTER_DARKNESS_UNDER_SKY);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.BROWN_GRIZZLE.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.CAVE_CRAWLER.get()), SpawnType.GROUND, CAVE_MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.CAVECLOPS.get()), SpawnType.GROUND, (en, s, t, p, r) -> EntityCaveclops.caveClopsSpawnRule(s, p) && SpawnEvents.difficultyFilter((EntityType<? extends Entity>)en, s, t, p, r) && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)s, (BlockPos)p, (RandomSource)r) && SpawnEvents.checkMobSpawnRules((EntityType<? extends Entity>)en, (LevelAccessor)s, t, p, r));
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.CRAB.get()), SpawnType.GROUND, MOB_UNDER_SKY);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.CYCLOPS.get()), SpawnType.GROUND, (en, s, t, p, r) -> EntityKobblin.kobblinSpawnRule((LevelAccessor)s, p));
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.DESERT_CRAWLER.get()), SpawnType.GROUND, MONSTER_DARKNESS_UNDER_SKY);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.DIAMOND_DAVE.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.EHU.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.ENTHRALLED_DRAMCRYX.get()), SpawnType.GROUND, (en, s, t, p, r) -> EntityEnthralledDramcryx.enthralledDramcryxSpawnRule(s, p) && SpawnEvents.difficultyFilter((EntityType<? extends Entity>)en, s, t, p, r) && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)s, (BlockPos)p, (RandomSource)r) && SpawnEvents.checkMobSpawnRules((EntityType<? extends Entity>)en, (LevelAccessor)s, t, p, r));
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.FROST.get()), SpawnType.AGILE, MONSTER_AGILE_UNDER_SKY);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.GLACON.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.HUSK.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.JACK_O_MAN.get()), SpawnType.GROUND, (en, s, t, p, r) -> SpawnEvents.checkMobSpawnRules((EntityType<? extends Entity>)en, (LevelAccessor)s, t, p, r) && EntityJackOMan.rules(s, p));
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.JUNGLE_BAT.get()), SpawnType.FLY, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.JUNGLE_DRAMCRYX.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.JUNGLE_SPIDER.get()), SpawnType.AGILE, DIFFICULTY_FILTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.KING_CRAB.get()), SpawnType.GROUND, MOB_UNDER_SKY);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.KOBBLIN.get()), SpawnType.GROUND, (en, s, t, p, r) -> SpawnEvents.difficultyFilter((EntityType<? extends Entity>)en, s, t, p, r) && EntityKobblin.kobblinSpawnRule((LevelAccessor)s, p) && s.canSeeSky(p));
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.LIOPLEURODON.get()), SpawnType.WATER, DIFFICULTY_FILTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.LIVESTOCK_MERCHANT.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.MINER.get()), SpawnType.GROUND, CAVE_MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.PUMPKIN_SPIDER.get()), SpawnType.GROUND, (en, s, t, p, r) -> SpawnEvents.difficultyFilter((EntityType<? extends Entity>)en, s, t, p, r) && EntityKobblin.kobblinSpawnRule((LevelAccessor)s, p));
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.RAINBOUR.get()), SpawnType.AGILE, DARKNESS_AGILE);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.ROTATICK.get()), SpawnType.GROUND, DEEPSLATE_MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SAGUARO_WORM.get()), SpawnType.GROUND, (en, s, t, p, r) -> SpawnEvents.difficultyFilter((EntityType<? extends Entity>)en, s, t, p, r) && EntitySaguaroWorm.saguaroWormSpawnRule((LevelAccessor)s, p));
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SHARK.get()), SpawnType.WATER, DIFFICULTY_FILTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SMELTER.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SNAPPER.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.STONE_GOLEM.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.THE_EYE.get()), SpawnType.GROUND, DEEPSLATE_MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.THE_GRUE.get()), SpawnType.GROUND, DEEPSLATE_MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.WHALE.get()), SpawnType.WATER, ALWAYS);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.WHITE_GRIZZLE.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.HELL_PIG.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.HELL_SPIDER.get()), SpawnType.AGILE, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SCORCHER.get()), SpawnType.FLY, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.WILDFIRE.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.ENDER_SPIDER.get()), SpawnType.AGILE, MONSTER_DARKNESS_AGILE);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.ENDER_TRIPLETS.get()), SpawnType.GROUND, (en, s, t, p, r) -> SpawnEvents.difficultyFilter((EntityType<? extends Entity>)en, s, t, p, r) && p.getY() > 60);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.ENDER_WATCHER.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.ENDER_SCROUNGE.get()), SpawnType.GROUND, DARKNESS);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.CAULDRON_FISH.get()), SpawnType.WATER, ALWAYS);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.BLUBBERTUSK.get()), SpawnType.WG_SURFACE, (en, s, t, p, r) -> {
            Holder b = s.getBiome(p);
            return b.is(DEEP_FROZEN_OCEAN) || b.is(FROZEN_OCEAN) || b.is(ICE_SHEET) || b.is(MORGUE_MARSH) || b.is(THERMAL_VENTS);
        });
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.DOLOSSAL.get()), SpawnType.WG_SURFACE, (en, s, t, p, r) -> {
            Holder b = s.getBiome(p);
            return b.is(BOREALIS_STEEPS) || b.is(COZYBARK_FOREST);
        });
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.MAMOTH.get()), SpawnType.WG_SURFACE, (en, s, t, p, r) -> {
            Holder b = s.getBiome(p);
            return b.is(COZYBARK_FOREST) || b.is(GLOWING_DEEP);
        });
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SNOW_SKIPPER.get()), SpawnType.AGILE, (en, s, t, p, r) -> {
            Holder b = s.getBiome(p);
            return b.is(SNOW_BOG) || b.is(SNOWY_PEAKS);
        });
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.PINK_GHOST_GLIDER.get()), SpawnType.WATER, ALWAYS);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SENG.get()), SpawnType.WG_SURFACE, (en, s, t, p, r) -> {
            Holder b = s.getBiome(p);
            return b.is(BOREALIS_STEEPS) || b.is(COZYBARK_FOREST) || b.is(FROZEN_PEAKS) || b.is(ICE_SPIKES) || b.is(SHIVERSPINE_FOREST);
        });
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SABEAR.get()), SpawnType.WG_SURFACE, (en, s, t, p, r) -> {
            Holder b = s.getBiome(p);
            return b.is(CHILL_PASSAGE) || b.is(FRACTAL_FOREST) || b.is(GEYSER_PLATEAU) || b.is(MORGUE_MARSH) || b.is(SHIVERSPINE_FOREST) || b.is(SNOWY_PEAKS);
        });
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.ALICANTO.get()), SpawnType.AGILE, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.FRACTITE.get()), SpawnType.AGILE, MONSTER_AGILE_UNDER_SKY);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.PALE_ARCHER.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.FROZEN_FLESH.get()), SpawnType.AGILE, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.GLACIDE.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.HASTREUS.get()), SpawnType.GROUND, MONSTER_DARKNESS);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.ROLLUM.get()), SpawnType.GROUND, (en, s, t, p, r) -> SpawnEvents.difficultyFilter((EntityType<? extends Entity>)en, s, t, p, r) && (MobSpawnType.isSpawner((MobSpawnType)t) || Monster.isDarkEnoughToSpawn((ServerLevelAccessor)s, (BlockPos)p, (RandomSource)r)) && SpawnEvents.checkMobSpawnRules((EntityType<? extends Entity>)en, (LevelAccessor)s, t, p, r));
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.WORKSHOP_MERCHANT.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.WORKSHOP_TINKERER.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.GROGLIN_HUNTER.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.GRUZZORLUG_MINER.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.ROBBIN.get()), SpawnType.WG_SURFACE, (en, s, t, p, r) -> {
            Holder b = s.getBiome(p);
            return b.is(COZYBARK_FOREST) || b.is(GEYSER_PLATEAU) || b.is(ICE_SPIKES) || b.is(MORGUE_MARSH) || b.is(SHIVERSPINE_FOREST);
        });
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.WOLPERTINGER.get()), SpawnType.WG_SURFACE, (en, s, t, p, r) -> {
            Holder b = s.getBiome(p);
            return b.is(COZYBARK_FOREST) || b.is(FRACTAL_FOREST) || b.is(GEYSER_PLATEAU) || b.is(ICE_SPIKES) || b.is(MORGUE_MARSH) || b.is(SHELTERED_GARDEN) || b.is(SHIVERSPINE_FOREST) || b.is(SNOWY_PEAKS) || b.is(TUNDRA);
        });
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.GLINTHOP.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.EDEN_CADILLION.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.EDEN_TOMO.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.GREENFEET.get()), SpawnType.GROUND, MONSTER_DARKNESS);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.MADIVEL.get()), SpawnType.GROUND, MONSTER_DARKNESS);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SUN_ARCHER.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.WEAK_CORI.get()), SpawnType.FLY, (en, s, t, p, r) -> SpawnEvents.difficultyFilter((EntityType<? extends Entity>)en, s, t, p, r) && EntityWeakCori.weakCoriSpawnRule(p, r));
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.BEHEMOTH.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.EPIPHITE.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.MAGE.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.MOON_WOLF.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.TERMID.get()), SpawnType.AGILE, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.VEREK.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.WILDWOOD_CADILLION.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.WILDWOOD_GOLEM.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.WILDWOOD_TOMO.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.APALACHIA_CADILLION.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.APALACHIA_GOLEM.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.APALACHIA_TOMO.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.ENCHANTED_ARCHER.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.ENCHANTED_WARRIOR.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SPELLBINDER.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.ADVANCED_CORI.get()), SpawnType.FLY, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.MEGALITH.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.MYSTIC.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SAMEK.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SKYTHERN_ARCHER.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SKYTHERN_FIEND.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SKYTHERN_GOLEM.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.ANGRY_GLINTHOP.get()), SpawnType.GROUND, MONSTER_DARKNESS);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.BASILISK.get()), SpawnType.GROUND, MONSTER_DARKNESS);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.DEMON_OF_DARKNESS.get()), SpawnType.GROUND, MONSTER_DARKNESS);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.MORTUM_CADILLION.get()), SpawnType.GROUND, MONSTER_DARKNESS);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SORCERER.get()), SpawnType.GROUND, MONSTER_DARKNESS);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SOUL_SPIDER.get()), SpawnType.GROUND, MONSTER_DARKNESS);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SOUL_STEALER.get()), SpawnType.GROUND, MONSTER_DARKNESS);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.TWILIGHT_ARCHER.get()), SpawnType.GROUND, MONSTER_DARKNESS);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.CAPTAIN_MERIK.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.DATTICON.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.DEATHCRYX.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.DEATH_HOUND.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.DUNGEON_CONSTRUCTOR.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.DUNGEON_DEMON.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.DUNGEON_PRISONER.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.FYRACRYX.get()), SpawnType.FLY, ALWAYS);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.GOLEM_OF_REJUVENATION.get()), SpawnType.AGILE, ALWAYS);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.KAZARI.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.LEORNA.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.LORD_VATTICUS.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.LIVING_STATUE.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.PARATIKU.get()), SpawnType.FLY, ALWAYS);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.RAZORBACK.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.ROAMER.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SEIMER.get()), SpawnType.FLY, ALWAYS);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SKYRE.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.WAR_GENERAL.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.WRAITH.get()), SpawnType.FLY, ALWAYS);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.ZELUS.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.ACID_HAG.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.BIPHRON.get()), SpawnType.AGILE, DIFFICULTY_FILTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.BOHEMITE.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.CRYPT_KEEPER.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.CYMESOID.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.DISSIMENT.get()), SpawnType.FLY, DIFFICULTY_FILTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.DREAMWRECKER.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.DUO.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.ENT.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.FAKE_VHRAAK.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.GALROID.get()), SpawnType.AGILE, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.GORGOSION.get()), SpawnType.AGILE, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.HELIO.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.HIVE_SOLDIER.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.HOVER_STINGER.get()), SpawnType.FLY, MONSTER_DARKNESS_AGILE);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.INSECT_FOURTEEN.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.KAZROTIC.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.LHEIVA.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.LORGA.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.LORGA_FLIGHT.get()), SpawnType.AGILE, DIFFICULTY_FILTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.MANDRAGORA.get()), SpawnType.AGILE, DIFFICULTY_FILTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.MYSTERIOUS_MAN_LAYER1.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.MYSTERIOUS_MAN_LAYER2.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.MYSTERIOUS_MAN_LAYER3.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.SHADAHIER.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.TEMPLE_GUARDIAN.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.THE_HUNGER.get()), SpawnType.GROUND, MOB);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.TOCAXIN.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.TWINS.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.VERMENOUS.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.VHRAAK.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.ZONE.get()), SpawnType.GROUND, MONSTER);
        SpawnEvents.register(e, (EntityType<? extends Entity>)((EntityType)EntityRegistry.ZORAGON.get()), SpawnType.FLY, DIFFICULTY_FILTER);
    }

    public static <T extends Entity> void register(RegisterSpawnPlacementsEvent e, EntityType<? extends Entity> t, SpawnType s, SpawnPlacements.SpawnPredicate<T> p) {
        e.register(t, s.placementType, s.heightMap, p, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static boolean difficultyFilter(EntityType<? extends Entity> e, ServerLevelAccessor s, MobSpawnType t, BlockPos p, RandomSource r) {
        return t != MobSpawnType.NATURAL || r.nextInt(10) >= cancellationChances.getOrDefault(s.getDifficulty(), 0);
    }

    public static boolean checkMobSpawnRules(EntityType<? extends Entity> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        BlockPos blockpos = pos.below();
        return spawnType == MobSpawnType.SPAWNER || level.getBlockState(blockpos).isValidSpawn((BlockGetter)level, blockpos, type);
    }

    public static enum SpawnType {
        WG_SURFACE(ON_BLOCK, Heightmap.Types.WORLD_SURFACE_WG),
        GROUND(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES),
        AGILE(ON_BLOCK, Heightmap.Types.MOTION_BLOCKING),
        FLY(SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING),
        OCEAN_FLOOR(SpawnPlacementTypes.IN_WATER, Heightmap.Types.OCEAN_FLOOR),
        WATER(SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING);

        public final SpawnPlacementType placementType;
        public final Heightmap.Types heightMap;

        private SpawnType(SpawnPlacementType placementType, Heightmap.Types heightMap) {
            this.placementType = placementType;
            this.heightMap = heightMap;
        }
    }
}

