/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import divinerpg.registries.BlockRegistry;
import divinerpg.registries.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class GlacialWallTotemEvent {
    @SubscribeEvent
    public void onPlayerHurt(LivingDamageEvent.Pre event) {
        Player player;
        if (event.getEntity() instanceof Player && (player = (Player)event.getEntity()).getInventory().getItem(40).is((Item)ItemRegistry.glacial_wall_totem.get()) && (double)player.getHealth() <= (double)player.getMaxHealth() * 0.2) {
            this.deployIcicleBarrier(player);
            player.getInventory().getItem(40).shrink(1);
            Level level = player.level();
            BlockPos playerPos = player.blockPosition();
            level.playSound(null, playerPos, SoundEvents.TOTEM_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private void deployIcicleBarrier(Player player) {
        Level level = player.level();
        BlockPos playerPos = player.blockPosition();
        int radius = 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = 0; y <= 4; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos blockPos = playerPos.offset(x, y, z);
                    boolean isOnEdge = Math.abs(x) == radius || Math.abs(z) == radius || y == 0 || y == 4;
                    boolean isAir = level.getBlockState(blockPos).isAir();
                    if (!isOnEdge || !isAir) continue;
                    level.setBlockAndUpdate(blockPos, ((Block)BlockRegistry.icicle.get()).defaultBlockState());
                }
            }
        }
        AABB box = new AABB((double)(-radius), 1.0, (double)(-radius), (double)radius, 4.0, (double)radius);
        level.getEntitiesOfClass(LivingEntity.class, box).stream().filter(entity -> entity != player && !(entity instanceof Player) && entity instanceof Mob).forEach(entity -> {
            double xDist = player.getX() - entity.getX();
            double zDist = player.getZ() - entity.getZ();
            double pushStrength = 3.0;
            entity.push(xDist * pushStrength, 0.5, zDist * pushStrength);
        });
    }
}

