/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.wildwood;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.entities.goals.EntityBehemothEatWood;
import divinerpg.registries.SoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public class EntityBehemoth
extends EntityDivineMonster {
    public EntityBehemoth(EntityType<? extends EntityBehemoth> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal<Player>(this, (PathfinderMob)this, Player.class, 12.0f, (double)1.1f, (double)1.2f){

            public boolean canUse() {
                return this.mob.getHealth() < this.mob.getMaxHealth() / 3.0f && super.canUse();
            }

            public boolean canContinueToUse() {
                return this.mob.getHealth() < this.mob.getMaxHealth() / 2.0f && super.canContinueToUse();
            }
        });
        this.goalSelector.addGoal(2, (Goal)new EntityBehemothEatWood(this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.0, this.followingTarget){

            public boolean canContinueToUse() {
                return this.mob.getHealth() >= this.mob.getMaxHealth() / 3.0f && super.canContinueToUse();
            }
        });
        this.goalSelector.addGoal(3, (Goal)new PanicGoal((PathfinderMob)this, (double)1.2f));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected float getSoundVolume() {
        return 0.7f;
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader world) {
        return 0.0f;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.ENDIKU.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.ENDIKU_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.ENDIKU_DEATH.get();
    }
}

