/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vethea;

import divinerpg.entities.base.EntityDivineFlyingMonster;
import divinerpg.entities.projectile.Bomb;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;

public class EntityZoragon
extends EntityDivineFlyingMonster
implements RangedAttackMob {
    public EntityZoragon(EntityType<? extends EntityZoragon> type, Level worldIn) {
        super(type, worldIn, 20.0f);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, this.getAttribute(Attributes.MOVEMENT_SPEED).getBaseValue(), 40, (float)this.getAttribute(Attributes.FOLLOW_RANGE).getBaseValue()));
        super.registerGoals();
    }

    public void performRangedAttack(LivingEntity entity, float range) {
        if (this.isAlive() && this.getTarget() != null && !this.level().isClientSide) {
            Bomb projectile = new Bomb((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.ZORAGON_BOMB.get()), this.level());
            projectile.setOwner((Entity)this);
            projectile.setPos(this.getEyePosition());
            double d0 = this.getTarget().getX() - this.getX();
            double d1 = this.getTarget().getY(0.3333333333333333) - projectile.getY();
            double d2 = this.getTarget().getZ() - this.getZ();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            projectile.shoot(d0, d1 + d3 * 0.2, d2, 1.6f, 0.8f);
            this.level().addFreshEntity((Entity)projectile);
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.ZORAGON.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.ZORAGON_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.ZORAGON_HURT.get();
    }
}

