/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vethea;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.entities.projectile.arrows.KarosArrow;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.SoundRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EntityZone
extends EntityDivineMonster
implements RangedAttackMob {
    public EntityZone(EntityType<? extends EntityZone> type, Level worldIn) {
        super(type, worldIn);
        this.setHealth(this.getMaxHealth());
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 0.25, 15, 40.0f));
        super.registerGoals();
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (this.isAlive() && this.getTarget() != null) {
            KarosArrow abstractarrow = new KarosArrow(this.level(), (LivingEntity)this, new ItemStack((ItemLike)ItemRegistry.karos_arrow.get()), new ItemStack((ItemLike)ItemRegistry.karos_bow.get()));
            abstractarrow.powerMultiplier = 2.5f;
            double d0 = target.getX() - this.getX();
            double d1 = target.getY(0.3333333333333333) - abstractarrow.getY();
            double d2 = target.getZ() - this.getZ();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            abstractarrow.shoot(d0, d1 + d3 * 0.2, d2, 1.6f, 14 - (this.level().getDifficulty().getId() << 2));
            this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)abstractarrow);
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.ZONE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.ZONE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.ZONE_HURT.get();
    }
}

