/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vethea;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.registries.SoundRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class EntityGorgosion
extends EntityDivineMonster {
    public EntityGorgosion(EntityType<? extends EntityGorgosion> type, Level worldIn) {
        super(type, worldIn);
    }

    public void tick() {
        super.tick();
        Player closestPlayer = this.level().getNearestPlayer((Entity)this, 10.0);
        if (closestPlayer != null && !closestPlayer.isCreative() && this.random.nextInt(30) == 0) {
            this.setDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y + 1.0, this.getDeltaMovement().z);
        }
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource damagesource) {
        if (distance > 2.0f) {
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 3.0f, false, Level.ExplosionInteraction.NONE);
            return false;
        }
        return super.causeFallDamage(distance, damageMultiplier, damagesource);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.GORGOSION.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.GORGOSION_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.GORGOSION_HURT.get();
    }
}

