/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vethea;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.registries.SoundRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityCymesoid
extends EntityDivineMonster {
    public EntityCymesoid(EntityType<? extends EntityCymesoid> type, Level worldIn) {
        super(type, worldIn);
    }

    public void tick() {
        super.tick();
        Player player = this.level().getNearestPlayer((Entity)this, 64.0);
        if (player != null && !player.isCreative()) {
            Vec3 playerLook = player.getLookAngle().normalize();
            Vec3 positionQuotient = new Vec3(this.getX() - player.getX(), this.getBoundingBox().minY + (double)(this.getEyeHeight() / 2.0f) - (player.getY() + (double)player.getEyeHeight()), this.getZ() - player.getZ());
            double distance = positionQuotient.length();
            double dotProduct = playerLook.dot(positionQuotient = positionQuotient.normalize());
            if (dotProduct > 1.0 - 0.025 / distance && player.hasLineOfSight((Entity)this)) {
                this.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 200, 1));
            }
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.CYMESOID.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.CYMESOID_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.CYMESOID_HURT.get();
    }
}

